/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadOnlyEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReadWriteEndpoint;
import com.azure.resourcemanager.sql.models.InstanceFailoverGroupReplicationRole;
import com.azure.resourcemanager.sql.models.ManagedInstancePairInfo;
import com.azure.resourcemanager.sql.models.PartnerRegionInfo;
import java.io.IOException;
import java.util.List;

public final class InstanceFailoverGroupProperties
implements JsonSerializable<InstanceFailoverGroupProperties> {
    private InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint;
    private InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint;
    private InstanceFailoverGroupReplicationRole replicationRole;
    private String replicationState;
    private List<PartnerRegionInfo> partnerRegions;
    private List<ManagedInstancePairInfo> managedInstancePairs;
    private static final ClientLogger LOGGER = new ClientLogger(InstanceFailoverGroupProperties.class);

    public InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint() {
        return this.readWriteEndpoint;
    }

    public InstanceFailoverGroupProperties withReadWriteEndpoint(InstanceFailoverGroupReadWriteEndpoint readWriteEndpoint) {
        this.readWriteEndpoint = readWriteEndpoint;
        return this;
    }

    public InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint() {
        return this.readOnlyEndpoint;
    }

    public InstanceFailoverGroupProperties withReadOnlyEndpoint(InstanceFailoverGroupReadOnlyEndpoint readOnlyEndpoint) {
        this.readOnlyEndpoint = readOnlyEndpoint;
        return this;
    }

    public InstanceFailoverGroupReplicationRole replicationRole() {
        return this.replicationRole;
    }

    public String replicationState() {
        return this.replicationState;
    }

    public List<PartnerRegionInfo> partnerRegions() {
        return this.partnerRegions;
    }

    public InstanceFailoverGroupProperties withPartnerRegions(List<PartnerRegionInfo> partnerRegions) {
        this.partnerRegions = partnerRegions;
        return this;
    }

    public List<ManagedInstancePairInfo> managedInstancePairs() {
        return this.managedInstancePairs;
    }

    public InstanceFailoverGroupProperties withManagedInstancePairs(List<ManagedInstancePairInfo> managedInstancePairs) {
        this.managedInstancePairs = managedInstancePairs;
        return this;
    }

    public void validate() {
        if (this.readWriteEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property readWriteEndpoint in model InstanceFailoverGroupProperties"));
        }
        this.readWriteEndpoint().validate();
        if (this.readOnlyEndpoint() != null) {
            this.readOnlyEndpoint().validate();
        }
        if (this.partnerRegions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property partnerRegions in model InstanceFailoverGroupProperties"));
        }
        this.partnerRegions().forEach(e -> e.validate());
        if (this.managedInstancePairs() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property managedInstancePairs in model InstanceFailoverGroupProperties"));
        }
        this.managedInstancePairs().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("readWriteEndpoint", (JsonSerializable)this.readWriteEndpoint);
        jsonWriter.writeArrayField("partnerRegions", this.partnerRegions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("managedInstancePairs", this.managedInstancePairs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("readOnlyEndpoint", (JsonSerializable)this.readOnlyEndpoint);
        return jsonWriter.writeEndObject();
    }

    public static InstanceFailoverGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (InstanceFailoverGroupProperties)jsonReader.readObject(reader -> {
            InstanceFailoverGroupProperties deserializedInstanceFailoverGroupProperties = new InstanceFailoverGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("readWriteEndpoint".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.readWriteEndpoint = InstanceFailoverGroupReadWriteEndpoint.fromJson(reader);
                    continue;
                }
                if ("partnerRegions".equals(fieldName)) {
                    List partnerRegions;
                    deserializedInstanceFailoverGroupProperties.partnerRegions = partnerRegions = reader.readArray(reader1 -> PartnerRegionInfo.fromJson(reader1));
                    continue;
                }
                if ("managedInstancePairs".equals(fieldName)) {
                    List managedInstancePairs;
                    deserializedInstanceFailoverGroupProperties.managedInstancePairs = managedInstancePairs = reader.readArray(reader1 -> ManagedInstancePairInfo.fromJson(reader1));
                    continue;
                }
                if ("readOnlyEndpoint".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.readOnlyEndpoint = InstanceFailoverGroupReadOnlyEndpoint.fromJson(reader);
                    continue;
                }
                if ("replicationRole".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.replicationRole = InstanceFailoverGroupReplicationRole.fromString(reader.getString());
                    continue;
                }
                if ("replicationState".equals(fieldName)) {
                    deserializedInstanceFailoverGroupProperties.replicationState = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInstanceFailoverGroupProperties;
        });
    }
}

