/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.DistributedAvailabilityGroupProperties;
import com.azure.resourcemanager.sql.models.ReplicationMode;
import java.io.IOException;
import java.util.UUID;

public final class DistributedAvailabilityGroupInner
extends ProxyResource {
    private DistributedAvailabilityGroupProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private DistributedAvailabilityGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String targetDatabase() {
        return this.innerProperties() == null ? null : this.innerProperties().targetDatabase();
    }

    public DistributedAvailabilityGroupInner withTargetDatabase(String targetDatabase) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DistributedAvailabilityGroupProperties();
        }
        this.innerProperties().withTargetDatabase(targetDatabase);
        return this;
    }

    public String sourceEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceEndpoint();
    }

    public DistributedAvailabilityGroupInner withSourceEndpoint(String sourceEndpoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DistributedAvailabilityGroupProperties();
        }
        this.innerProperties().withSourceEndpoint(sourceEndpoint);
        return this;
    }

    public String primaryAvailabilityGroupName() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryAvailabilityGroupName();
    }

    public DistributedAvailabilityGroupInner withPrimaryAvailabilityGroupName(String primaryAvailabilityGroupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DistributedAvailabilityGroupProperties();
        }
        this.innerProperties().withPrimaryAvailabilityGroupName(primaryAvailabilityGroupName);
        return this;
    }

    public String secondaryAvailabilityGroupName() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryAvailabilityGroupName();
    }

    public DistributedAvailabilityGroupInner withSecondaryAvailabilityGroupName(String secondaryAvailabilityGroupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DistributedAvailabilityGroupProperties();
        }
        this.innerProperties().withSecondaryAvailabilityGroupName(secondaryAvailabilityGroupName);
        return this;
    }

    public ReplicationMode replicationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationMode();
    }

    public DistributedAvailabilityGroupInner withReplicationMode(ReplicationMode replicationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DistributedAvailabilityGroupProperties();
        }
        this.innerProperties().withReplicationMode(replicationMode);
        return this;
    }

    public UUID distributedAvailabilityGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().distributedAvailabilityGroupId();
    }

    public UUID sourceReplicaId() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceReplicaId();
    }

    public UUID targetReplicaId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetReplicaId();
    }

    public String linkState() {
        return this.innerProperties() == null ? null : this.innerProperties().linkState();
    }

    public String lastHardenedLsn() {
        return this.innerProperties() == null ? null : this.innerProperties().lastHardenedLsn();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static DistributedAvailabilityGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (DistributedAvailabilityGroupInner)((Object)jsonReader.readObject(reader -> {
            DistributedAvailabilityGroupInner deserializedDistributedAvailabilityGroupInner = new DistributedAvailabilityGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDistributedAvailabilityGroupInner.innerProperties = DistributedAvailabilityGroupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDistributedAvailabilityGroupInner;
        }));
    }
}

