/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.VaultProperties;
import java.io.IOException;
import java.util.Map;

public final class VaultCreateOrUpdateParameters
implements JsonSerializable<VaultCreateOrUpdateParameters> {
    private String location;
    private Map<String, String> tags;
    private VaultProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(VaultCreateOrUpdateParameters.class);

    public String location() {
        return this.location;
    }

    public VaultCreateOrUpdateParameters withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VaultCreateOrUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public VaultProperties properties() {
        return this.properties;
    }

    public VaultCreateOrUpdateParameters withProperties(VaultProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model VaultCreateOrUpdateParameters"));
        }
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model VaultCreateOrUpdateParameters"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VaultCreateOrUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VaultCreateOrUpdateParameters)jsonReader.readObject(reader -> {
            VaultCreateOrUpdateParameters deserializedVaultCreateOrUpdateParameters = new VaultCreateOrUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedVaultCreateOrUpdateParameters.location = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVaultCreateOrUpdateParameters.properties = VaultProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVaultCreateOrUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVaultCreateOrUpdateParameters;
        });
    }
}

