/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.ContainerState;
import com.azure.resourcemanager.containerinstance.models.Event;
import java.io.IOException;
import java.util.List;

public final class ContainerPropertiesInstanceView
implements JsonSerializable<ContainerPropertiesInstanceView> {
    private Integer restartCount;
    private ContainerState currentState;
    private ContainerState previousState;
    private List<Event> events;

    public Integer restartCount() {
        return this.restartCount;
    }

    public ContainerState currentState() {
        return this.currentState;
    }

    public ContainerState previousState() {
        return this.previousState;
    }

    public List<Event> events() {
        return this.events;
    }

    public void validate() {
        if (this.currentState() != null) {
            this.currentState().validate();
        }
        if (this.previousState() != null) {
            this.previousState().validate();
        }
        if (this.events() != null) {
            this.events().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ContainerPropertiesInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (ContainerPropertiesInstanceView)jsonReader.readObject(reader -> {
            ContainerPropertiesInstanceView deserializedContainerPropertiesInstanceView = new ContainerPropertiesInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restartCount".equals(fieldName)) {
                    deserializedContainerPropertiesInstanceView.restartCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("currentState".equals(fieldName)) {
                    deserializedContainerPropertiesInstanceView.currentState = ContainerState.fromJson(reader);
                    continue;
                }
                if ("previousState".equals(fieldName)) {
                    deserializedContainerPropertiesInstanceView.previousState = ContainerState.fromJson(reader);
                    continue;
                }
                if ("events".equals(fieldName)) {
                    List events;
                    deserializedContainerPropertiesInstanceView.events = events = reader.readArray(reader1 -> Event.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerPropertiesInstanceView;
        });
    }
}

