/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.Credentials;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TaskStepProperties;
import com.azure.resourcemanager.containerregistry.models.TriggerProperties;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class TaskProperties
implements JsonSerializable<TaskProperties> {
    private ProvisioningState provisioningState;
    private OffsetDateTime creationDate;
    private TaskStatus status;
    private PlatformProperties platform;
    private AgentProperties agentConfiguration;
    private String agentPoolName;
    private Integer timeout;
    private TaskStepProperties step;
    private TriggerProperties trigger;
    private Credentials credentials;
    private String logTemplate;
    private Boolean isSystemTask;

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public TaskStatus status() {
        return this.status;
    }

    public TaskProperties withStatus(TaskStatus status) {
        this.status = status;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public TaskProperties withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public TaskProperties withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String agentPoolName() {
        return this.agentPoolName;
    }

    public TaskProperties withAgentPoolName(String agentPoolName) {
        this.agentPoolName = agentPoolName;
        return this;
    }

    public Integer timeout() {
        return this.timeout;
    }

    public TaskProperties withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public TaskStepProperties step() {
        return this.step;
    }

    public TaskProperties withStep(TaskStepProperties step) {
        this.step = step;
        return this;
    }

    public TriggerProperties trigger() {
        return this.trigger;
    }

    public TaskProperties withTrigger(TriggerProperties trigger) {
        this.trigger = trigger;
        return this;
    }

    public Credentials credentials() {
        return this.credentials;
    }

    public TaskProperties withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public String logTemplate() {
        return this.logTemplate;
    }

    public TaskProperties withLogTemplate(String logTemplate) {
        this.logTemplate = logTemplate;
        return this;
    }

    public Boolean isSystemTask() {
        return this.isSystemTask;
    }

    public TaskProperties withIsSystemTask(Boolean isSystemTask) {
        this.isSystemTask = isSystemTask;
        return this;
    }

    public void validate() {
        if (this.platform() != null) {
            this.platform().validate();
        }
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.step() != null) {
            this.step().validate();
        }
        if (this.trigger() != null) {
            this.trigger().validate();
        }
        if (this.credentials() != null) {
            this.credentials().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeJsonField("platform", (JsonSerializable)this.platform);
        jsonWriter.writeJsonField("agentConfiguration", (JsonSerializable)this.agentConfiguration);
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName);
        jsonWriter.writeNumberField("timeout", (Number)this.timeout);
        jsonWriter.writeJsonField("step", (JsonSerializable)this.step);
        jsonWriter.writeJsonField("trigger", (JsonSerializable)this.trigger);
        jsonWriter.writeJsonField("credentials", (JsonSerializable)this.credentials);
        jsonWriter.writeStringField("logTemplate", this.logTemplate);
        jsonWriter.writeBooleanField("isSystemTask", this.isSystemTask);
        return jsonWriter.writeEndObject();
    }

    public static TaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (TaskProperties)jsonReader.readObject(reader -> {
            TaskProperties deserializedTaskProperties = new TaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedTaskProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedTaskProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTaskProperties.status = TaskStatus.fromString(reader.getString());
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedTaskProperties.platform = PlatformProperties.fromJson(reader);
                    continue;
                }
                if ("agentConfiguration".equals(fieldName)) {
                    deserializedTaskProperties.agentConfiguration = AgentProperties.fromJson(reader);
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedTaskProperties.agentPoolName = reader.getString();
                    continue;
                }
                if ("timeout".equals(fieldName)) {
                    deserializedTaskProperties.timeout = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("step".equals(fieldName)) {
                    deserializedTaskProperties.step = TaskStepProperties.fromJson(reader);
                    continue;
                }
                if ("trigger".equals(fieldName)) {
                    deserializedTaskProperties.trigger = TriggerProperties.fromJson(reader);
                    continue;
                }
                if ("credentials".equals(fieldName)) {
                    deserializedTaskProperties.credentials = Credentials.fromJson(reader);
                    continue;
                }
                if ("logTemplate".equals(fieldName)) {
                    deserializedTaskProperties.logTemplate = reader.getString();
                    continue;
                }
                if ("isSystemTask".equals(fieldName)) {
                    deserializedTaskProperties.isSystemTask = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTaskProperties;
        });
    }
}

