/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.EventHubsManager;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.models.ArmDisasterRecoveryInner;
import com.azure.resourcemanager.eventhubs.implementation.Ancestors;
import com.azure.resourcemanager.eventhubs.implementation.EventHubNamespaceImpl;
import com.azure.resourcemanager.eventhubs.implementation.NestedResourceImpl;
import com.azure.resourcemanager.eventhubs.models.DisasterRecoveryPairingAuthorizationRule;
import com.azure.resourcemanager.eventhubs.models.EventHubDisasterRecoveryPairing;
import com.azure.resourcemanager.eventhubs.models.EventHubNamespace;
import com.azure.resourcemanager.eventhubs.models.ProvisioningStateDR;
import com.azure.resourcemanager.eventhubs.models.RoleDisasterRecovery;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import reactor.core.publisher.Mono;

class EventHubDisasterRecoveryPairingImpl
extends NestedResourceImpl<EventHubDisasterRecoveryPairing, ArmDisasterRecoveryInner, EventHubDisasterRecoveryPairingImpl>
implements EventHubDisasterRecoveryPairing,
EventHubDisasterRecoveryPairing.Definition,
EventHubDisasterRecoveryPairing.Update {
    private Ancestors.OneAncestor ancestor;
    private final ClientLogger logger = new ClientLogger(EventHubDisasterRecoveryPairingImpl.class);

    EventHubDisasterRecoveryPairingImpl(String name, ArmDisasterRecoveryInner inner, EventHubsManager manager) {
        super(name, inner, manager);
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(inner.id());
    }

    EventHubDisasterRecoveryPairingImpl(String name, EventHubsManager manager) {
        super(name, new ArmDisasterRecoveryInner(), manager);
    }

    @Override
    public String primaryNamespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String primaryNamespaceName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public String secondaryNamespaceId() {
        return ((ArmDisasterRecoveryInner)((Object)this.innerModel())).partnerNamespace();
    }

    @Override
    public RoleDisasterRecovery namespaceRole() {
        return ((ArmDisasterRecoveryInner)((Object)this.innerModel())).role();
    }

    @Override
    public ProvisioningStateDR provisioningState() {
        return ((ArmDisasterRecoveryInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withNewPrimaryNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        if (namespaceCreatable instanceof EventHubNamespaceImpl) {
            EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
            this.ancestor = new Ancestors().new Ancestors.OneAncestor(namespace.resourceGroupName(), namespaceCreatable.name());
        } else {
            this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The namespaceCreatable is invalid."));
        }
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespace(EventHubNamespace namespace) {
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(this.selfId(namespace.id()));
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespace(String resourceGroupName, String primaryNamespaceName) {
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(resourceGroupName, primaryNamespaceName);
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingPrimaryNamespaceId(String namespaceId) {
        this.ancestor = new Ancestors().new Ancestors.OneAncestor(this.selfId(namespaceId));
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withNewSecondaryNamespace(Creatable<EventHubNamespace> namespaceCreatable) {
        this.addDependency(namespaceCreatable);
        if (namespaceCreatable instanceof EventHubNamespaceImpl) {
            EventHubNamespaceImpl namespace = (EventHubNamespaceImpl)namespaceCreatable;
            ((ArmDisasterRecoveryInner)((Object)this.innerModel())).withPartnerNamespace(namespace.name());
        } else {
            this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The namespaceCreatable is invalid."));
        }
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingSecondaryNamespace(EventHubNamespace namespace) {
        Objects.requireNonNull(namespace.id());
        ((ArmDisasterRecoveryInner)((Object)this.innerModel())).withPartnerNamespace(namespace.id());
        return this;
    }

    @Override
    public EventHubDisasterRecoveryPairingImpl withExistingSecondaryNamespaceId(String namespaceId) {
        Objects.requireNonNull(namespaceId);
        ((ArmDisasterRecoveryInner)((Object)this.innerModel())).withPartnerNamespace(namespaceId);
        return this;
    }

    public Mono<EventHubDisasterRecoveryPairing> createResourceAsync() {
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name(), (ArmDisasterRecoveryInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public Mono<Void> breakPairingAsync() {
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().breakPairingAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name()).then(this.refreshAsync()).then();
    }

    @Override
    public void breakPairing() {
        this.breakPairingAsync().block();
    }

    @Override
    public Mono<Void> failOverAsync() {
        ResourceId secondaryNs = ResourceId.fromString((String)((ArmDisasterRecoveryInner)((Object)this.innerModel())).partnerNamespace());
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().failOverAsync(secondaryNs.resourceGroupName(), secondaryNs.name(), this.name()).then(this.refreshAsync()).then();
    }

    @Override
    public void failOver() {
        this.failOverAsync().block();
    }

    @Override
    public PagedFlux<DisasterRecoveryPairingAuthorizationRule> listAuthorizationRulesAsync() {
        return this.manager().disasterRecoveryPairingAuthorizationRules().listByDisasterRecoveryPairingAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public PagedIterable<DisasterRecoveryPairingAuthorizationRule> listAuthorizationRules() {
        return this.manager().disasterRecoveryPairingAuthorizationRules().listByDisasterRecoveryPairing(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    protected Mono<ArmDisasterRecoveryInner> getInnerAsync() {
        return ((EventHubManagementClient)this.manager().serviceClient()).getDisasterRecoveryConfigs().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.OneAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/disasterRecoveryConfig/%s", parentId, this.name());
    }
}

