/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.CaptureDescription;
import com.azure.resourcemanager.eventhubs.models.EntityStatus;
import com.azure.resourcemanager.eventhubs.models.RetentionDescription;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class EventhubProperties
implements JsonSerializable<EventhubProperties> {
    private List<String> partitionIds;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private Long messageRetentionInDays;
    private Long partitionCount;
    private EntityStatus status;
    private String userMetadata;
    private CaptureDescription captureDescription;
    private RetentionDescription retentionDescription;

    public List<String> partitionIds() {
        return this.partitionIds;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public Long messageRetentionInDays() {
        return this.messageRetentionInDays;
    }

    public EventhubProperties withMessageRetentionInDays(Long messageRetentionInDays) {
        this.messageRetentionInDays = messageRetentionInDays;
        return this;
    }

    public Long partitionCount() {
        return this.partitionCount;
    }

    public EventhubProperties withPartitionCount(Long partitionCount) {
        this.partitionCount = partitionCount;
        return this;
    }

    public EntityStatus status() {
        return this.status;
    }

    public EventhubProperties withStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String userMetadata() {
        return this.userMetadata;
    }

    public EventhubProperties withUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public CaptureDescription captureDescription() {
        return this.captureDescription;
    }

    public EventhubProperties withCaptureDescription(CaptureDescription captureDescription) {
        this.captureDescription = captureDescription;
        return this;
    }

    public RetentionDescription retentionDescription() {
        return this.retentionDescription;
    }

    public EventhubProperties withRetentionDescription(RetentionDescription retentionDescription) {
        this.retentionDescription = retentionDescription;
        return this;
    }

    public void validate() {
        if (this.captureDescription() != null) {
            this.captureDescription().validate();
        }
        if (this.retentionDescription() != null) {
            this.retentionDescription().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("messageRetentionInDays", (Number)this.messageRetentionInDays);
        jsonWriter.writeNumberField("partitionCount", (Number)this.partitionCount);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("userMetadata", this.userMetadata);
        jsonWriter.writeJsonField("captureDescription", (JsonSerializable)this.captureDescription);
        jsonWriter.writeJsonField("retentionDescription", (JsonSerializable)this.retentionDescription);
        return jsonWriter.writeEndObject();
    }

    public static EventhubProperties fromJson(JsonReader jsonReader) throws IOException {
        return (EventhubProperties)jsonReader.readObject(reader -> {
            EventhubProperties deserializedEventhubProperties = new EventhubProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partitionIds".equals(fieldName)) {
                    List partitionIds;
                    deserializedEventhubProperties.partitionIds = partitionIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("createdAt".equals(fieldName)) {
                    deserializedEventhubProperties.createdAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedAt".equals(fieldName)) {
                    deserializedEventhubProperties.updatedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("messageRetentionInDays".equals(fieldName)) {
                    deserializedEventhubProperties.messageRetentionInDays = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("partitionCount".equals(fieldName)) {
                    deserializedEventhubProperties.partitionCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEventhubProperties.status = EntityStatus.fromString(reader.getString());
                    continue;
                }
                if ("userMetadata".equals(fieldName)) {
                    deserializedEventhubProperties.userMetadata = reader.getString();
                    continue;
                }
                if ("captureDescription".equals(fieldName)) {
                    deserializedEventhubProperties.captureDescription = CaptureDescription.fromJson(reader);
                    continue;
                }
                if ("retentionDescription".equals(fieldName)) {
                    deserializedEventhubProperties.retentionDescription = RetentionDescription.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEventhubProperties;
        });
    }
}

