/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class RecurrentSchedule
implements JsonSerializable<RecurrentSchedule> {
    private String timeZone;
    private List<String> days;
    private List<Integer> hours;
    private List<Integer> minutes;
    private static final ClientLogger LOGGER = new ClientLogger(RecurrentSchedule.class);

    public String timeZone() {
        return this.timeZone;
    }

    public RecurrentSchedule withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public List<String> days() {
        return this.days;
    }

    public RecurrentSchedule withDays(List<String> days) {
        this.days = days;
        return this;
    }

    public List<Integer> hours() {
        return this.hours;
    }

    public RecurrentSchedule withHours(List<Integer> hours) {
        this.hours = hours;
        return this;
    }

    public List<Integer> minutes() {
        return this.minutes;
    }

    public RecurrentSchedule withMinutes(List<Integer> minutes) {
        this.minutes = minutes;
        return this;
    }

    public void validate() {
        if (this.timeZone() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeZone in model RecurrentSchedule"));
        }
        if (this.days() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property days in model RecurrentSchedule"));
        }
        if (this.hours() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property hours in model RecurrentSchedule"));
        }
        if (this.minutes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property minutes in model RecurrentSchedule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeZone", this.timeZone);
        jsonWriter.writeArrayField("days", this.days, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("hours", this.hours, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("minutes", this.minutes, (writer, element) -> writer.writeInt(element.intValue()));
        return jsonWriter.writeEndObject();
    }

    public static RecurrentSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (RecurrentSchedule)jsonReader.readObject(reader -> {
            RecurrentSchedule deserializedRecurrentSchedule = new RecurrentSchedule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeZone".equals(fieldName)) {
                    deserializedRecurrentSchedule.timeZone = reader.getString();
                    continue;
                }
                if ("days".equals(fieldName)) {
                    List days;
                    deserializedRecurrentSchedule.days = days = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("hours".equals(fieldName)) {
                    List hours;
                    deserializedRecurrentSchedule.hours = hours = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("minutes".equals(fieldName)) {
                    List minutes;
                    deserializedRecurrentSchedule.minutes = minutes = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRecurrentSchedule;
        });
    }
}

