/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.AzureMonitorPrivateLinkScopeProperties;
import com.azure.resourcemanager.monitor.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.monitor.models.AccessModeSettings;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AzureMonitorPrivateLinkScopeInner
extends Resource {
    private AzureMonitorPrivateLinkScopeProperties innerProperties = new AzureMonitorPrivateLinkScopeProperties();
    private SystemData systemData;
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorPrivateLinkScopeInner.class);

    private AzureMonitorPrivateLinkScopeProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AzureMonitorPrivateLinkScopeInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AzureMonitorPrivateLinkScopeInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public AccessModeSettings accessModeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().accessModeSettings();
    }

    public AzureMonitorPrivateLinkScopeInner withAccessModeSettings(AccessModeSettings accessModeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AzureMonitorPrivateLinkScopeProperties();
        }
        this.innerProperties().withAccessModeSettings(accessModeSettings);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model AzureMonitorPrivateLinkScopeInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AzureMonitorPrivateLinkScopeInner fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMonitorPrivateLinkScopeInner)((Object)jsonReader.readObject(reader -> {
            AzureMonitorPrivateLinkScopeInner deserializedAzureMonitorPrivateLinkScopeInner = new AzureMonitorPrivateLinkScopeInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAzureMonitorPrivateLinkScopeInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeInner.innerProperties = AzureMonitorPrivateLinkScopeProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMonitorPrivateLinkScopeInner;
        }));
    }
}

