/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.fluent.models.ScheduleEntries;
import com.azure.resourcemanager.redis.models.ScheduleEntry;
import java.io.IOException;
import java.util.List;

public final class RedisPatchScheduleInner
extends ProxyResource {
    private ScheduleEntries innerProperties = new ScheduleEntries();
    private String location;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(RedisPatchScheduleInner.class);

    private ScheduleEntries innerProperties() {
        return this.innerProperties;
    }

    public String location() {
        return this.location;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public List<ScheduleEntry> scheduleEntries() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduleEntries();
    }

    public RedisPatchScheduleInner withScheduleEntries(List<ScheduleEntry> scheduleEntries) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScheduleEntries();
        }
        this.innerProperties().withScheduleEntries(scheduleEntries);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RedisPatchScheduleInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RedisPatchScheduleInner fromJson(JsonReader jsonReader) throws IOException {
        return (RedisPatchScheduleInner)((Object)jsonReader.readObject(reader -> {
            RedisPatchScheduleInner deserializedRedisPatchScheduleInner = new RedisPatchScheduleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.innerProperties = ScheduleEntries.fromJson(reader);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRedisPatchScheduleInner.location = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisPatchScheduleInner;
        }));
    }
}

