/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.redis.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.redis.models.AccessPolicyProvisioningState;
import com.azure.resourcemanager.redis.models.AccessPolicyType;
import java.io.IOException;

public final class RedisCacheAccessPolicyProperties
implements JsonSerializable<RedisCacheAccessPolicyProperties> {
    private AccessPolicyProvisioningState provisioningState;
    private AccessPolicyType type;
    private String permissions;
    private static final ClientLogger LOGGER = new ClientLogger(RedisCacheAccessPolicyProperties.class);

    public AccessPolicyProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public AccessPolicyType type() {
        return this.type;
    }

    public String permissions() {
        return this.permissions;
    }

    public RedisCacheAccessPolicyProperties withPermissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public void validate() {
        if (this.permissions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property permissions in model RedisCacheAccessPolicyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("permissions", this.permissions);
        return jsonWriter.writeEndObject();
    }

    public static RedisCacheAccessPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RedisCacheAccessPolicyProperties)jsonReader.readObject(reader -> {
            RedisCacheAccessPolicyProperties deserializedRedisCacheAccessPolicyProperties = new RedisCacheAccessPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("permissions".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyProperties.permissions = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyProperties.provisioningState = AccessPolicyProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRedisCacheAccessPolicyProperties.type = AccessPolicyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRedisCacheAccessPolicyProperties;
        });
    }
}

