/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.MigrationState;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ImmutableStorageWithVersioning
implements JsonSerializable<ImmutableStorageWithVersioning> {
    private Boolean enabled;
    private OffsetDateTime timestamp;
    private MigrationState migrationState;

    public Boolean enabled() {
        return this.enabled;
    }

    public ImmutableStorageWithVersioning withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public MigrationState migrationState() {
        return this.migrationState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        return jsonWriter.writeEndObject();
    }

    public static ImmutableStorageWithVersioning fromJson(JsonReader jsonReader) throws IOException {
        return (ImmutableStorageWithVersioning)jsonReader.readObject(reader -> {
            ImmutableStorageWithVersioning deserializedImmutableStorageWithVersioning = new ImmutableStorageWithVersioning();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedImmutableStorageWithVersioning.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("timeStamp".equals(fieldName)) {
                    deserializedImmutableStorageWithVersioning.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("migrationState".equals(fieldName)) {
                    deserializedImmutableStorageWithVersioning.migrationState = MigrationState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImmutableStorageWithVersioning;
        });
    }
}

