/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.TenantIdDescriptionInner;
import java.io.IOException;
import java.util.List;

public final class TenantListResult
implements JsonSerializable<TenantListResult> {
    private List<TenantIdDescriptionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(TenantListResult.class);

    public List<TenantIdDescriptionInner> value() {
        return this.value;
    }

    public TenantListResult withValue(List<TenantIdDescriptionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public TenantListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
        if (this.nextLink() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property nextLink in model TenantListResult"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TenantListResult fromJson(JsonReader jsonReader) throws IOException {
        return (TenantListResult)jsonReader.readObject(reader -> {
            TenantListResult deserializedTenantListResult = new TenantListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nextLink".equals(fieldName)) {
                    deserializedTenantListResult.nextLink = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedTenantListResult.value = value = reader.readArray(reader1 -> TenantIdDescriptionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTenantListResult;
        });
    }
}

