/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DeploymentExternalInputDefinition
implements JsonSerializable<DeploymentExternalInputDefinition> {
    private String kind;
    private Object config;
    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExternalInputDefinition.class);

    public String kind() {
        return this.kind;
    }

    public DeploymentExternalInputDefinition withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public Object config() {
        return this.config;
    }

    public DeploymentExternalInputDefinition withConfig(Object config) {
        this.config = config;
        return this;
    }

    public void validate() {
        if (this.kind() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property kind in model DeploymentExternalInputDefinition"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind);
        if (this.config != null) {
            jsonWriter.writeUntypedField("config", this.config);
        }
        return jsonWriter.writeEndObject();
    }

    public static DeploymentExternalInputDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentExternalInputDefinition)jsonReader.readObject(reader -> {
            DeploymentExternalInputDefinition deserializedDeploymentExternalInputDefinition = new DeploymentExternalInputDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedDeploymentExternalInputDefinition.kind = reader.getString();
                    continue;
                }
                if ("config".equals(fieldName)) {
                    deserializedDeploymentExternalInputDefinition.config = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentExternalInputDefinition;
        });
    }
}

