/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.GatewayApiRoute;
import com.azure.resourcemanager.appplatform.models.GatewayProvisioningState;
import com.azure.resourcemanager.appplatform.models.GatewayRouteConfigOpenApiProperties;
import com.azure.resourcemanager.appplatform.models.GatewayRouteConfigProtocol;
import java.io.IOException;
import java.util.List;

public final class GatewayRouteConfigProperties
implements JsonSerializable<GatewayRouteConfigProperties> {
    private GatewayProvisioningState provisioningState;
    private String appResourceId;
    private GatewayRouteConfigOpenApiProperties openApi;
    private GatewayRouteConfigProtocol protocol;
    private List<GatewayApiRoute> routes;
    private Boolean ssoEnabled;
    private List<String> predicates;
    private List<String> filters;

    public GatewayProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String appResourceId() {
        return this.appResourceId;
    }

    public GatewayRouteConfigProperties withAppResourceId(String appResourceId) {
        this.appResourceId = appResourceId;
        return this;
    }

    public GatewayRouteConfigOpenApiProperties openApi() {
        return this.openApi;
    }

    public GatewayRouteConfigProperties withOpenApi(GatewayRouteConfigOpenApiProperties openApi) {
        this.openApi = openApi;
        return this;
    }

    public GatewayRouteConfigProtocol protocol() {
        return this.protocol;
    }

    public GatewayRouteConfigProperties withProtocol(GatewayRouteConfigProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<GatewayApiRoute> routes() {
        return this.routes;
    }

    public GatewayRouteConfigProperties withRoutes(List<GatewayApiRoute> routes) {
        this.routes = routes;
        return this;
    }

    public Boolean ssoEnabled() {
        return this.ssoEnabled;
    }

    public GatewayRouteConfigProperties withSsoEnabled(Boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
        return this;
    }

    public List<String> predicates() {
        return this.predicates;
    }

    public GatewayRouteConfigProperties withPredicates(List<String> predicates) {
        this.predicates = predicates;
        return this;
    }

    public List<String> filters() {
        return this.filters;
    }

    public GatewayRouteConfigProperties withFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public void validate() {
        if (this.openApi() != null) {
            this.openApi().validate();
        }
        if (this.routes() != null) {
            this.routes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("appResourceId", this.appResourceId);
        jsonWriter.writeJsonField("openApi", (JsonSerializable)this.openApi);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("ssoEnabled", this.ssoEnabled);
        jsonWriter.writeArrayField("predicates", this.predicates, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static GatewayRouteConfigProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GatewayRouteConfigProperties)jsonReader.readObject(reader -> {
            GatewayRouteConfigProperties deserializedGatewayRouteConfigProperties = new GatewayRouteConfigProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.provisioningState = GatewayProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("appResourceId".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.appResourceId = reader.getString();
                    continue;
                }
                if ("openApi".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.openApi = GatewayRouteConfigOpenApiProperties.fromJson(reader);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.protocol = GatewayRouteConfigProtocol.fromString(reader.getString());
                    continue;
                }
                if ("routes".equals(fieldName)) {
                    List routes;
                    deserializedGatewayRouteConfigProperties.routes = routes = reader.readArray(reader1 -> GatewayApiRoute.fromJson(reader1));
                    continue;
                }
                if ("ssoEnabled".equals(fieldName)) {
                    deserializedGatewayRouteConfigProperties.ssoEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("predicates".equals(fieldName)) {
                    List predicates;
                    deserializedGatewayRouteConfigProperties.predicates = predicates = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedGatewayRouteConfigProperties.filters = filters = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGatewayRouteConfigProperties;
        });
    }
}

