/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AcceleratorAuthSetting;
import java.io.IOException;

public final class AcceleratorGitRepository
implements JsonSerializable<AcceleratorGitRepository> {
    private String url;
    private Integer intervalInSeconds;
    private String branch;
    private String commit;
    private String gitTag;
    private AcceleratorAuthSetting authSetting;
    private String subPath;
    private static final ClientLogger LOGGER = new ClientLogger(AcceleratorGitRepository.class);

    public String url() {
        return this.url;
    }

    public AcceleratorGitRepository withUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer intervalInSeconds() {
        return this.intervalInSeconds;
    }

    public AcceleratorGitRepository withIntervalInSeconds(Integer intervalInSeconds) {
        this.intervalInSeconds = intervalInSeconds;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public AcceleratorGitRepository withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public String commit() {
        return this.commit;
    }

    public AcceleratorGitRepository withCommit(String commit) {
        this.commit = commit;
        return this;
    }

    public String gitTag() {
        return this.gitTag;
    }

    public AcceleratorGitRepository withGitTag(String gitTag) {
        this.gitTag = gitTag;
        return this;
    }

    public AcceleratorAuthSetting authSetting() {
        return this.authSetting;
    }

    public AcceleratorGitRepository withAuthSetting(AcceleratorAuthSetting authSetting) {
        this.authSetting = authSetting;
        return this;
    }

    public String subPath() {
        return this.subPath;
    }

    public AcceleratorGitRepository withSubPath(String subPath) {
        this.subPath = subPath;
        return this;
    }

    public void validate() {
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model AcceleratorGitRepository"));
        }
        if (this.authSetting() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authSetting in model AcceleratorGitRepository"));
        }
        this.authSetting().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeJsonField("authSetting", (JsonSerializable)this.authSetting);
        jsonWriter.writeNumberField("intervalInSeconds", (Number)this.intervalInSeconds);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeStringField("commit", this.commit);
        jsonWriter.writeStringField("gitTag", this.gitTag);
        jsonWriter.writeStringField("subPath", this.subPath);
        return jsonWriter.writeEndObject();
    }

    public static AcceleratorGitRepository fromJson(JsonReader jsonReader) throws IOException {
        return (AcceleratorGitRepository)jsonReader.readObject(reader -> {
            AcceleratorGitRepository deserializedAcceleratorGitRepository = new AcceleratorGitRepository();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.url = reader.getString();
                    continue;
                }
                if ("authSetting".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.authSetting = AcceleratorAuthSetting.fromJson(reader);
                    continue;
                }
                if ("intervalInSeconds".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.intervalInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.branch = reader.getString();
                    continue;
                }
                if ("commit".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.commit = reader.getString();
                    continue;
                }
                if ("gitTag".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.gitTag = reader.getString();
                    continue;
                }
                if ("subPath".equals(fieldName)) {
                    deserializedAcceleratorGitRepository.subPath = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcceleratorGitRepository;
        });
    }
}

