/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleEntityTheme;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftActivity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphShiftItem;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOpenShiftItem
extends MicrosoftGraphShiftItem {
    private Integer openSlotCount;
    private Map<String, Object> additionalProperties;

    public Integer openSlotCount() {
        return this.openSlotCount;
    }

    public MicrosoftGraphOpenShiftItem withOpenSlotCount(Integer openSlotCount) {
        this.openSlotCount = openSlotCount;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withActivities(List<MicrosoftGraphShiftActivity> activities) {
        super.withActivities(activities);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withDisplayName(String displayName) {
        super.withDisplayName(displayName);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withNotes(String notes) {
        super.withNotes(notes);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withEndDateTime(OffsetDateTime endDateTime) {
        super.withEndDateTime(endDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withStartDateTime(OffsetDateTime startDateTime) {
        super.withStartDateTime(startDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOpenShiftItem withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        super.withTheme(theme);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endDateTime", this.endDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime()));
        jsonWriter.writeStringField("startDateTime", this.startDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime()));
        jsonWriter.writeStringField("theme", this.theme() == null ? null : this.theme().toString());
        jsonWriter.writeArrayField("activities", this.activities(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("displayName", this.displayName());
        jsonWriter.writeStringField("notes", this.notes());
        jsonWriter.writeNumberField("openSlotCount", (Number)this.openSlotCount);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOpenShiftItem fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOpenShiftItem)jsonReader.readObject(reader -> {
            MicrosoftGraphOpenShiftItem deserializedMicrosoftGraphOpenShiftItem = new MicrosoftGraphOpenShiftItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShiftItem.withEndDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShiftItem.withStartDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShiftItem.withTheme(MicrosoftGraphScheduleEntityTheme.fromString(reader.getString()));
                    continue;
                }
                if ("activities".equals(fieldName)) {
                    List activities = reader.readArray(reader1 -> MicrosoftGraphShiftActivity.fromJson(reader1));
                    deserializedMicrosoftGraphOpenShiftItem.withActivities(activities);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShiftItem.withDisplayName(reader.getString());
                    continue;
                }
                if ("notes".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShiftItem.withNotes(reader.getString());
                    continue;
                }
                if ("openSlotCount".equals(fieldName)) {
                    deserializedMicrosoftGraphOpenShiftItem.openSlotCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOpenShiftItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOpenShiftItem;
        });
    }
}

