/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphComplianceStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDeviceCompliancePolicySettingState;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPolicyPlatformType;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphDeviceCompliancePolicyState
extends MicrosoftGraphEntity {
    private String displayName;
    private MicrosoftGraphPolicyPlatformType platformType;
    private Integer settingCount;
    private List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates;
    private MicrosoftGraphComplianceStatus state;
    private Integer version;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphDeviceCompliancePolicyState withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MicrosoftGraphPolicyPlatformType platformType() {
        return this.platformType;
    }

    public MicrosoftGraphDeviceCompliancePolicyState withPlatformType(MicrosoftGraphPolicyPlatformType platformType) {
        this.platformType = platformType;
        return this;
    }

    public Integer settingCount() {
        return this.settingCount;
    }

    public MicrosoftGraphDeviceCompliancePolicyState withSettingCount(Integer settingCount) {
        this.settingCount = settingCount;
        return this;
    }

    public List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates() {
        return this.settingStates;
    }

    public MicrosoftGraphDeviceCompliancePolicyState withSettingStates(List<MicrosoftGraphDeviceCompliancePolicySettingState> settingStates) {
        this.settingStates = settingStates;
        return this;
    }

    public MicrosoftGraphComplianceStatus state() {
        return this.state;
    }

    public MicrosoftGraphDeviceCompliancePolicyState withState(MicrosoftGraphComplianceStatus state) {
        this.state = state;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public MicrosoftGraphDeviceCompliancePolicyState withVersion(Integer version) {
        this.version = version;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphDeviceCompliancePolicyState withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphDeviceCompliancePolicyState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.settingStates() != null) {
            this.settingStates().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("platformType", this.platformType == null ? null : this.platformType.toString());
        jsonWriter.writeNumberField("settingCount", (Number)this.settingCount);
        jsonWriter.writeArrayField("settingStates", this.settingStates, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeNumberField("version", (Number)this.version);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphDeviceCompliancePolicyState fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphDeviceCompliancePolicyState)jsonReader.readObject(reader -> {
            MicrosoftGraphDeviceCompliancePolicyState deserializedMicrosoftGraphDeviceCompliancePolicyState = new MicrosoftGraphDeviceCompliancePolicyState();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.withId(reader.getString());
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.displayName = reader.getString();
                    continue;
                }
                if ("platformType".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.platformType = MicrosoftGraphPolicyPlatformType.fromString(reader.getString());
                    continue;
                }
                if ("settingCount".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.settingCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("settingStates".equals(fieldName)) {
                    List settingStates;
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.settingStates = settingStates = reader.readArray(reader1 -> MicrosoftGraphDeviceCompliancePolicySettingState.fromJson(reader1));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.state = MicrosoftGraphComplianceStatus.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceCompliancePolicyState.version = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphDeviceCompliancePolicyState.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphDeviceCompliancePolicyState;
        });
    }
}

