/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeleteRule;
import com.azure.resourcemanager.cdn.models.UpdateRule;
import java.io.IOException;

public final class KeyVaultCertificateSourceParameters
implements JsonSerializable<KeyVaultCertificateSourceParameters> {
    private String typeName = "KeyVaultCertificateSourceParameters";
    private String subscriptionId;
    private String resourceGroupName;
    private String vaultName;
    private String secretName;
    private String secretVersion;
    private UpdateRule updateRule;
    private DeleteRule deleteRule;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultCertificateSourceParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public KeyVaultCertificateSourceParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public KeyVaultCertificateSourceParameters withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public KeyVaultCertificateSourceParameters withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public String vaultName() {
        return this.vaultName;
    }

    public KeyVaultCertificateSourceParameters withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    public String secretName() {
        return this.secretName;
    }

    public KeyVaultCertificateSourceParameters withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    public String secretVersion() {
        return this.secretVersion;
    }

    public KeyVaultCertificateSourceParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    public UpdateRule updateRule() {
        return this.updateRule;
    }

    public KeyVaultCertificateSourceParameters withUpdateRule(UpdateRule updateRule) {
        this.updateRule = updateRule;
        return this;
    }

    public DeleteRule deleteRule() {
        return this.deleteRule;
    }

    public KeyVaultCertificateSourceParameters withDeleteRule(DeleteRule deleteRule) {
        this.deleteRule = deleteRule;
        return this;
    }

    public void validate() {
        if (this.subscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subscriptionId in model KeyVaultCertificateSourceParameters"));
        }
        if (this.resourceGroupName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property resourceGroupName in model KeyVaultCertificateSourceParameters"));
        }
        if (this.vaultName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vaultName in model KeyVaultCertificateSourceParameters"));
        }
        if (this.secretName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretName in model KeyVaultCertificateSourceParameters"));
        }
        if (this.updateRule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property updateRule in model KeyVaultCertificateSourceParameters"));
        }
        if (this.deleteRule() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deleteRule in model KeyVaultCertificateSourceParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("resourceGroupName", this.resourceGroupName);
        jsonWriter.writeStringField("vaultName", this.vaultName);
        jsonWriter.writeStringField("secretName", this.secretName);
        jsonWriter.writeStringField("updateRule", this.updateRule == null ? null : this.updateRule.toString());
        jsonWriter.writeStringField("deleteRule", this.deleteRule == null ? null : this.deleteRule.toString());
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultCertificateSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultCertificateSourceParameters)jsonReader.readObject(reader -> {
            KeyVaultCertificateSourceParameters deserializedKeyVaultCertificateSourceParameters = new KeyVaultCertificateSourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("subscriptionId".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.subscriptionId = reader.getString();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.resourceGroupName = reader.getString();
                    continue;
                }
                if ("vaultName".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.vaultName = reader.getString();
                    continue;
                }
                if ("secretName".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.secretName = reader.getString();
                    continue;
                }
                if ("updateRule".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.updateRule = UpdateRule.fromString(reader.getString());
                    continue;
                }
                if ("deleteRule".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.deleteRule = DeleteRule.fromString(reader.getString());
                    continue;
                }
                if ("secretVersion".equals(fieldName)) {
                    deserializedKeyVaultCertificateSourceParameters.secretVersion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultCertificateSourceParameters;
        });
    }
}

