/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CacheBehavior;
import com.azure.resourcemanager.cdn.models.CacheType;
import java.io.IOException;

public final class CacheExpirationActionParameters
implements JsonSerializable<CacheExpirationActionParameters> {
    private String typeName = "DeliveryRuleCacheExpirationActionParameters";
    private CacheBehavior cacheBehavior;
    private CacheType cacheType;
    private String cacheDuration;
    private static final ClientLogger LOGGER = new ClientLogger(CacheExpirationActionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public CacheExpirationActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public CacheBehavior cacheBehavior() {
        return this.cacheBehavior;
    }

    public CacheExpirationActionParameters withCacheBehavior(CacheBehavior cacheBehavior) {
        this.cacheBehavior = cacheBehavior;
        return this;
    }

    public CacheType cacheType() {
        return this.cacheType;
    }

    public CacheExpirationActionParameters withCacheType(CacheType cacheType) {
        this.cacheType = cacheType;
        return this;
    }

    public String cacheDuration() {
        return this.cacheDuration;
    }

    public CacheExpirationActionParameters withCacheDuration(String cacheDuration) {
        this.cacheDuration = cacheDuration;
        return this;
    }

    public void validate() {
        if (this.cacheBehavior() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cacheBehavior in model CacheExpirationActionParameters"));
        }
        if (this.cacheType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property cacheType in model CacheExpirationActionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("cacheBehavior", this.cacheBehavior == null ? null : this.cacheBehavior.toString());
        jsonWriter.writeStringField("cacheType", this.cacheType == null ? null : this.cacheType.toString());
        jsonWriter.writeStringField("cacheDuration", this.cacheDuration);
        return jsonWriter.writeEndObject();
    }

    public static CacheExpirationActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CacheExpirationActionParameters)jsonReader.readObject(reader -> {
            CacheExpirationActionParameters deserializedCacheExpirationActionParameters = new CacheExpirationActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cacheBehavior".equals(fieldName)) {
                    deserializedCacheExpirationActionParameters.cacheBehavior = CacheBehavior.fromString(reader.getString());
                    continue;
                }
                if ("cacheType".equals(fieldName)) {
                    deserializedCacheExpirationActionParameters.cacheType = CacheType.fromString(reader.getString());
                    continue;
                }
                if ("cacheDuration".equals(fieldName)) {
                    deserializedCacheExpirationActionParameters.cacheDuration = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCacheExpirationActionParameters;
        });
    }
}

