/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appplatform.models.AcceleratorAuthSetting;
import java.io.IOException;

public final class AcceleratorSshSetting
extends AcceleratorAuthSetting {
    private String authType = "SSH";
    private String hostKey;
    private String hostKeyAlgorithm;
    private String privateKey;

    @Override
    public String authType() {
        return this.authType;
    }

    public String hostKey() {
        return this.hostKey;
    }

    public AcceleratorSshSetting withHostKey(String hostKey) {
        this.hostKey = hostKey;
        return this;
    }

    public String hostKeyAlgorithm() {
        return this.hostKeyAlgorithm;
    }

    public AcceleratorSshSetting withHostKeyAlgorithm(String hostKeyAlgorithm) {
        this.hostKeyAlgorithm = hostKeyAlgorithm;
        return this;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public AcceleratorSshSetting withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authType", this.authType);
        jsonWriter.writeStringField("hostKey", this.hostKey);
        jsonWriter.writeStringField("hostKeyAlgorithm", this.hostKeyAlgorithm);
        jsonWriter.writeStringField("privateKey", this.privateKey);
        return jsonWriter.writeEndObject();
    }

    public static AcceleratorSshSetting fromJson(JsonReader jsonReader) throws IOException {
        return (AcceleratorSshSetting)jsonReader.readObject(reader -> {
            AcceleratorSshSetting deserializedAcceleratorSshSetting = new AcceleratorSshSetting();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authType".equals(fieldName)) {
                    deserializedAcceleratorSshSetting.authType = reader.getString();
                    continue;
                }
                if ("hostKey".equals(fieldName)) {
                    deserializedAcceleratorSshSetting.hostKey = reader.getString();
                    continue;
                }
                if ("hostKeyAlgorithm".equals(fieldName)) {
                    deserializedAcceleratorSshSetting.hostKeyAlgorithm = reader.getString();
                    continue;
                }
                if ("privateKey".equals(fieldName)) {
                    deserializedAcceleratorSshSetting.privateKey = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAcceleratorSshSetting;
        });
    }
}

