/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphBaseItemInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphColumnDefinition;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphContentType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDrive;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemAnalytics;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphList;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenote;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPublicError;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharepointIds;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSiteCollection;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphSite
extends MicrosoftGraphBaseItemInner {
    private String displayName;
    private MicrosoftGraphPublicError error;
    private Map<String, Object> root;
    private MicrosoftGraphSharepointIds sharepointIds;
    private MicrosoftGraphSiteCollection siteCollection;
    private MicrosoftGraphItemAnalytics analytics;
    private List<MicrosoftGraphColumnDefinition> columns;
    private List<MicrosoftGraphContentType> contentTypes;
    private MicrosoftGraphDrive drive;
    private List<MicrosoftGraphDrive> drives;
    private List<MicrosoftGraphBaseItemInner> items;
    private List<MicrosoftGraphList> lists;
    private List<MicrosoftGraphSite> sites;
    private MicrosoftGraphOnenote onenote;
    private Map<String, Object> additionalProperties;

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphSite withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public MicrosoftGraphPublicError error() {
        return this.error;
    }

    public MicrosoftGraphSite withError(MicrosoftGraphPublicError error) {
        this.error = error;
        return this;
    }

    public Map<String, Object> root() {
        return this.root;
    }

    public MicrosoftGraphSite withRoot(Map<String, Object> root) {
        this.root = root;
        return this;
    }

    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    public MicrosoftGraphSite withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    public MicrosoftGraphSiteCollection siteCollection() {
        return this.siteCollection;
    }

    public MicrosoftGraphSite withSiteCollection(MicrosoftGraphSiteCollection siteCollection) {
        this.siteCollection = siteCollection;
        return this;
    }

    public MicrosoftGraphItemAnalytics analytics() {
        return this.analytics;
    }

    public MicrosoftGraphSite withAnalytics(MicrosoftGraphItemAnalytics analytics) {
        this.analytics = analytics;
        return this;
    }

    public List<MicrosoftGraphColumnDefinition> columns() {
        return this.columns;
    }

    public MicrosoftGraphSite withColumns(List<MicrosoftGraphColumnDefinition> columns) {
        this.columns = columns;
        return this;
    }

    public List<MicrosoftGraphContentType> contentTypes() {
        return this.contentTypes;
    }

    public MicrosoftGraphSite withContentTypes(List<MicrosoftGraphContentType> contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    public MicrosoftGraphDrive drive() {
        return this.drive;
    }

    public MicrosoftGraphSite withDrive(MicrosoftGraphDrive drive) {
        this.drive = drive;
        return this;
    }

    public List<MicrosoftGraphDrive> drives() {
        return this.drives;
    }

    public MicrosoftGraphSite withDrives(List<MicrosoftGraphDrive> drives) {
        this.drives = drives;
        return this;
    }

    public List<MicrosoftGraphBaseItemInner> items() {
        return this.items;
    }

    public MicrosoftGraphSite withItems(List<MicrosoftGraphBaseItemInner> items) {
        this.items = items;
        return this;
    }

    public List<MicrosoftGraphList> lists() {
        return this.lists;
    }

    public MicrosoftGraphSite withLists(List<MicrosoftGraphList> lists) {
        this.lists = lists;
        return this;
    }

    public List<MicrosoftGraphSite> sites() {
        return this.sites;
    }

    public MicrosoftGraphSite withSites(List<MicrosoftGraphSite> sites) {
        this.sites = sites;
        return this;
    }

    public MicrosoftGraphOnenote onenote() {
        return this.onenote;
    }

    public MicrosoftGraphSite withOnenote(MicrosoftGraphOnenote onenote) {
        this.onenote = onenote;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphSite withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphSite withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    @Override
    public MicrosoftGraphSite withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphSite withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MicrosoftGraphSite withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    @Override
    public MicrosoftGraphSite withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphSite withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphSite withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MicrosoftGraphSite withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    @Override
    public MicrosoftGraphSite withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    @Override
    public MicrosoftGraphSite withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    @Override
    public MicrosoftGraphSite withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    @Override
    public MicrosoftGraphSite withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.sharepointIds() != null) {
            this.sharepointIds().validate();
        }
        if (this.siteCollection() != null) {
            this.siteCollection().validate();
        }
        if (this.analytics() != null) {
            this.analytics().validate();
        }
        if (this.columns() != null) {
            this.columns().forEach(e -> e.validate());
        }
        if (this.contentTypes() != null) {
            this.contentTypes().forEach(e -> e.validate());
        }
        if (this.drive() != null) {
            this.drive().validate();
        }
        if (this.drives() != null) {
            this.drives().forEach(e -> e.validate());
        }
        if (this.items() != null) {
            this.items().forEach(e -> e.validate());
        }
        if (this.lists() != null) {
            this.lists().forEach(e -> e.validate());
        }
        if (this.sites() != null) {
            this.sites().forEach(e -> e.validate());
        }
        if (this.onenote() != null) {
            this.onenote().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("parentReference", (JsonSerializable)this.parentReference());
        jsonWriter.writeStringField("webUrl", this.webUrl());
        jsonWriter.writeJsonField("createdByUser", (JsonSerializable)this.createdByUser());
        jsonWriter.writeJsonField("lastModifiedByUser", (JsonSerializable)this.lastModifiedByUser());
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeMapField("root", this.root, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("sharepointIds", (JsonSerializable)this.sharepointIds);
        jsonWriter.writeJsonField("siteCollection", (JsonSerializable)this.siteCollection);
        jsonWriter.writeJsonField("analytics", (JsonSerializable)this.analytics);
        jsonWriter.writeArrayField("columns", this.columns, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("contentTypes", this.contentTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("drive", (JsonSerializable)this.drive);
        jsonWriter.writeArrayField("drives", this.drives, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("items", this.items, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("lists", this.lists, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sites", this.sites, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("onenote", (JsonSerializable)this.onenote);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphSite fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphSite)jsonReader.readObject(reader -> {
            MicrosoftGraphSite deserializedMicrosoftGraphSite = new MicrosoftGraphSite();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withId(reader.getString());
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withDescription(reader.getString());
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withEtag(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withName(reader.getString());
                    continue;
                }
                if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withParentReference(MicrosoftGraphItemReference.fromJson(reader));
                    continue;
                }
                if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withWebUrl(reader.getString());
                    continue;
                }
                if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withCreatedByUser(MicrosoftGraphUserInner.fromJson(reader));
                    continue;
                }
                if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.withLastModifiedByUser(MicrosoftGraphUserInner.fromJson(reader));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.displayName = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.error = MicrosoftGraphPublicError.fromJson(reader);
                    continue;
                }
                if ("root".equals(fieldName)) {
                    Map root;
                    deserializedMicrosoftGraphSite.root = root = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("sharepointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.sharepointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                    continue;
                }
                if ("siteCollection".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.siteCollection = MicrosoftGraphSiteCollection.fromJson(reader);
                    continue;
                }
                if ("analytics".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.analytics = MicrosoftGraphItemAnalytics.fromJson(reader);
                    continue;
                }
                if ("columns".equals(fieldName)) {
                    List columns;
                    deserializedMicrosoftGraphSite.columns = columns = reader.readArray(reader1 -> MicrosoftGraphColumnDefinition.fromJson(reader1));
                    continue;
                }
                if ("contentTypes".equals(fieldName)) {
                    List contentTypes;
                    deserializedMicrosoftGraphSite.contentTypes = contentTypes = reader.readArray(reader1 -> MicrosoftGraphContentType.fromJson(reader1));
                    continue;
                }
                if ("drive".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.drive = MicrosoftGraphDrive.fromJson(reader);
                    continue;
                }
                if ("drives".equals(fieldName)) {
                    List drives;
                    deserializedMicrosoftGraphSite.drives = drives = reader.readArray(reader1 -> MicrosoftGraphDrive.fromJson(reader1));
                    continue;
                }
                if ("items".equals(fieldName)) {
                    List items;
                    deserializedMicrosoftGraphSite.items = items = reader.readArray(reader1 -> MicrosoftGraphBaseItemInner.fromJson(reader1));
                    continue;
                }
                if ("lists".equals(fieldName)) {
                    List lists;
                    deserializedMicrosoftGraphSite.lists = lists = reader.readArray(reader1 -> MicrosoftGraphList.fromJson(reader1));
                    continue;
                }
                if ("sites".equals(fieldName)) {
                    List sites;
                    deserializedMicrosoftGraphSite.sites = sites = reader.readArray(reader1 -> MicrosoftGraphSite.fromJson(reader1));
                    continue;
                }
                if ("onenote".equals(fieldName)) {
                    deserializedMicrosoftGraphSite.onenote = MicrosoftGraphOnenote.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphSite.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphSite;
        });
    }
}

