/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAssignedPlan;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphCertificateBasedAuthConfiguration;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtension;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMdmAuthority;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPrivacyProfile;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphProvisionedPlan;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphVerifiedDomain;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOrganization
extends MicrosoftGraphDirectoryObjectInner {
    private List<MicrosoftGraphAssignedPlan> assignedPlans;
    private List<String> businessPhones;
    private String city;
    private String country;
    private String countryLetterCode;
    private OffsetDateTime createdDateTime;
    private String displayName;
    private List<String> marketingNotificationEmails;
    private OffsetDateTime onPremisesLastSyncDateTime;
    private Boolean onPremisesSyncEnabled;
    private String postalCode;
    private String preferredLanguage;
    private MicrosoftGraphPrivacyProfile privacyProfile;
    private List<MicrosoftGraphProvisionedPlan> provisionedPlans;
    private List<String> securityComplianceNotificationMails;
    private List<String> securityComplianceNotificationPhones;
    private String state;
    private String street;
    private List<String> technicalNotificationMails;
    private String tenantType;
    private List<MicrosoftGraphVerifiedDomain> verifiedDomains;
    private MicrosoftGraphMdmAuthority mobileDeviceManagementAuthority;
    private List<MicrosoftGraphCertificateBasedAuthConfiguration> certificateBasedAuthConfiguration;
    private List<MicrosoftGraphExtension> extensions;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphAssignedPlan> assignedPlans() {
        return this.assignedPlans;
    }

    public MicrosoftGraphOrganization withAssignedPlans(List<MicrosoftGraphAssignedPlan> assignedPlans) {
        this.assignedPlans = assignedPlans;
        return this;
    }

    public List<String> businessPhones() {
        return this.businessPhones;
    }

    public MicrosoftGraphOrganization withBusinessPhones(List<String> businessPhones) {
        this.businessPhones = businessPhones;
        return this;
    }

    public String city() {
        return this.city;
    }

    public MicrosoftGraphOrganization withCity(String city) {
        this.city = city;
        return this;
    }

    public String country() {
        return this.country;
    }

    public MicrosoftGraphOrganization withCountry(String country) {
        this.country = country;
        return this;
    }

    public String countryLetterCode() {
        return this.countryLetterCode;
    }

    public MicrosoftGraphOrganization withCountryLetterCode(String countryLetterCode) {
        this.countryLetterCode = countryLetterCode;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphOrganization withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphOrganization withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public List<String> marketingNotificationEmails() {
        return this.marketingNotificationEmails;
    }

    public MicrosoftGraphOrganization withMarketingNotificationEmails(List<String> marketingNotificationEmails) {
        this.marketingNotificationEmails = marketingNotificationEmails;
        return this;
    }

    public OffsetDateTime onPremisesLastSyncDateTime() {
        return this.onPremisesLastSyncDateTime;
    }

    public MicrosoftGraphOrganization withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return this;
    }

    public Boolean onPremisesSyncEnabled() {
        return this.onPremisesSyncEnabled;
    }

    public MicrosoftGraphOrganization withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        this.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return this;
    }

    public String postalCode() {
        return this.postalCode;
    }

    public MicrosoftGraphOrganization withPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    public String preferredLanguage() {
        return this.preferredLanguage;
    }

    public MicrosoftGraphOrganization withPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
        return this;
    }

    public MicrosoftGraphPrivacyProfile privacyProfile() {
        return this.privacyProfile;
    }

    public MicrosoftGraphOrganization withPrivacyProfile(MicrosoftGraphPrivacyProfile privacyProfile) {
        this.privacyProfile = privacyProfile;
        return this;
    }

    public List<MicrosoftGraphProvisionedPlan> provisionedPlans() {
        return this.provisionedPlans;
    }

    public MicrosoftGraphOrganization withProvisionedPlans(List<MicrosoftGraphProvisionedPlan> provisionedPlans) {
        this.provisionedPlans = provisionedPlans;
        return this;
    }

    public List<String> securityComplianceNotificationMails() {
        return this.securityComplianceNotificationMails;
    }

    public MicrosoftGraphOrganization withSecurityComplianceNotificationMails(List<String> securityComplianceNotificationMails) {
        this.securityComplianceNotificationMails = securityComplianceNotificationMails;
        return this;
    }

    public List<String> securityComplianceNotificationPhones() {
        return this.securityComplianceNotificationPhones;
    }

    public MicrosoftGraphOrganization withSecurityComplianceNotificationPhones(List<String> securityComplianceNotificationPhones) {
        this.securityComplianceNotificationPhones = securityComplianceNotificationPhones;
        return this;
    }

    public String state() {
        return this.state;
    }

    public MicrosoftGraphOrganization withState(String state) {
        this.state = state;
        return this;
    }

    public String street() {
        return this.street;
    }

    public MicrosoftGraphOrganization withStreet(String street) {
        this.street = street;
        return this;
    }

    public List<String> technicalNotificationMails() {
        return this.technicalNotificationMails;
    }

    public MicrosoftGraphOrganization withTechnicalNotificationMails(List<String> technicalNotificationMails) {
        this.technicalNotificationMails = technicalNotificationMails;
        return this;
    }

    public String tenantType() {
        return this.tenantType;
    }

    public MicrosoftGraphOrganization withTenantType(String tenantType) {
        this.tenantType = tenantType;
        return this;
    }

    public List<MicrosoftGraphVerifiedDomain> verifiedDomains() {
        return this.verifiedDomains;
    }

    public MicrosoftGraphOrganization withVerifiedDomains(List<MicrosoftGraphVerifiedDomain> verifiedDomains) {
        this.verifiedDomains = verifiedDomains;
        return this;
    }

    public MicrosoftGraphMdmAuthority mobileDeviceManagementAuthority() {
        return this.mobileDeviceManagementAuthority;
    }

    public MicrosoftGraphOrganization withMobileDeviceManagementAuthority(MicrosoftGraphMdmAuthority mobileDeviceManagementAuthority) {
        this.mobileDeviceManagementAuthority = mobileDeviceManagementAuthority;
        return this;
    }

    public List<MicrosoftGraphCertificateBasedAuthConfiguration> certificateBasedAuthConfiguration() {
        return this.certificateBasedAuthConfiguration;
    }

    public MicrosoftGraphOrganization withCertificateBasedAuthConfiguration(List<MicrosoftGraphCertificateBasedAuthConfiguration> certificateBasedAuthConfiguration) {
        this.certificateBasedAuthConfiguration = certificateBasedAuthConfiguration;
        return this;
    }

    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    public MicrosoftGraphOrganization withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOrganization withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOrganization withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphOrganization withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.assignedPlans() != null) {
            this.assignedPlans().forEach(e -> e.validate());
        }
        if (this.privacyProfile() != null) {
            this.privacyProfile().validate();
        }
        if (this.provisionedPlans() != null) {
            this.provisionedPlans().forEach(e -> e.validate());
        }
        if (this.verifiedDomains() != null) {
            this.verifiedDomains().forEach(e -> e.validate());
        }
        if (this.certificateBasedAuthConfiguration() != null) {
            this.certificateBasedAuthConfiguration().forEach(e -> e.validate());
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeArrayField("assignedPlans", this.assignedPlans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("businessPhones", this.businessPhones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("city", this.city);
        jsonWriter.writeStringField("country", this.country);
        jsonWriter.writeStringField("countryLetterCode", this.countryLetterCode);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeArrayField("marketingNotificationEmails", this.marketingNotificationEmails, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("onPremisesLastSyncDateTime", this.onPremisesLastSyncDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.onPremisesLastSyncDateTime));
        jsonWriter.writeBooleanField("onPremisesSyncEnabled", this.onPremisesSyncEnabled);
        jsonWriter.writeStringField("postalCode", this.postalCode);
        jsonWriter.writeStringField("preferredLanguage", this.preferredLanguage);
        jsonWriter.writeJsonField("privacyProfile", (JsonSerializable)this.privacyProfile);
        jsonWriter.writeArrayField("provisionedPlans", this.provisionedPlans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("securityComplianceNotificationMails", this.securityComplianceNotificationMails, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("securityComplianceNotificationPhones", this.securityComplianceNotificationPhones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("street", this.street);
        jsonWriter.writeArrayField("technicalNotificationMails", this.technicalNotificationMails, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("tenantType", this.tenantType);
        jsonWriter.writeArrayField("verifiedDomains", this.verifiedDomains, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("mobileDeviceManagementAuthority", this.mobileDeviceManagementAuthority == null ? null : this.mobileDeviceManagementAuthority.toString());
        jsonWriter.writeArrayField("certificateBasedAuthConfiguration", this.certificateBasedAuthConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOrganization fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOrganization)jsonReader.readObject(reader -> {
            MicrosoftGraphOrganization deserializedMicrosoftGraphOrganization = new MicrosoftGraphOrganization();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("assignedPlans".equals(fieldName)) {
                    List assignedPlans;
                    deserializedMicrosoftGraphOrganization.assignedPlans = assignedPlans = reader.readArray(reader1 -> MicrosoftGraphAssignedPlan.fromJson(reader1));
                    continue;
                }
                if ("businessPhones".equals(fieldName)) {
                    List businessPhones;
                    deserializedMicrosoftGraphOrganization.businessPhones = businessPhones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("city".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.city = reader.getString();
                    continue;
                }
                if ("country".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.country = reader.getString();
                    continue;
                }
                if ("countryLetterCode".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.countryLetterCode = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.displayName = reader.getString();
                    continue;
                }
                if ("marketingNotificationEmails".equals(fieldName)) {
                    List marketingNotificationEmails;
                    deserializedMicrosoftGraphOrganization.marketingNotificationEmails = marketingNotificationEmails = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("onPremisesLastSyncDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.onPremisesLastSyncDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("onPremisesSyncEnabled".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.onPremisesSyncEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("postalCode".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.postalCode = reader.getString();
                    continue;
                }
                if ("preferredLanguage".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.preferredLanguage = reader.getString();
                    continue;
                }
                if ("privacyProfile".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.privacyProfile = MicrosoftGraphPrivacyProfile.fromJson(reader);
                    continue;
                }
                if ("provisionedPlans".equals(fieldName)) {
                    List provisionedPlans;
                    deserializedMicrosoftGraphOrganization.provisionedPlans = provisionedPlans = reader.readArray(reader1 -> MicrosoftGraphProvisionedPlan.fromJson(reader1));
                    continue;
                }
                if ("securityComplianceNotificationMails".equals(fieldName)) {
                    List securityComplianceNotificationMails;
                    deserializedMicrosoftGraphOrganization.securityComplianceNotificationMails = securityComplianceNotificationMails = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("securityComplianceNotificationPhones".equals(fieldName)) {
                    List securityComplianceNotificationPhones;
                    deserializedMicrosoftGraphOrganization.securityComplianceNotificationPhones = securityComplianceNotificationPhones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.state = reader.getString();
                    continue;
                }
                if ("street".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.street = reader.getString();
                    continue;
                }
                if ("technicalNotificationMails".equals(fieldName)) {
                    List technicalNotificationMails;
                    deserializedMicrosoftGraphOrganization.technicalNotificationMails = technicalNotificationMails = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tenantType".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.tenantType = reader.getString();
                    continue;
                }
                if ("verifiedDomains".equals(fieldName)) {
                    List verifiedDomains;
                    deserializedMicrosoftGraphOrganization.verifiedDomains = verifiedDomains = reader.readArray(reader1 -> MicrosoftGraphVerifiedDomain.fromJson(reader1));
                    continue;
                }
                if ("mobileDeviceManagementAuthority".equals(fieldName)) {
                    deserializedMicrosoftGraphOrganization.mobileDeviceManagementAuthority = MicrosoftGraphMdmAuthority.fromString(reader.getString());
                    continue;
                }
                if ("certificateBasedAuthConfiguration".equals(fieldName)) {
                    List certificateBasedAuthConfiguration;
                    deserializedMicrosoftGraphOrganization.certificateBasedAuthConfiguration = certificateBasedAuthConfiguration = reader.readArray(reader1 -> MicrosoftGraphCertificateBasedAuthConfiguration.fromJson(reader1));
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedMicrosoftGraphOrganization.extensions = extensions = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOrganization.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOrganization;
        });
    }
}

