/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.ManagedClusterManagedOutboundIpProfile;
import com.azure.resourcemanager.containerservice.models.ResourceReference;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterNatGatewayProfile
implements JsonSerializable<ManagedClusterNatGatewayProfile> {
    private ManagedClusterManagedOutboundIpProfile managedOutboundIpProfile;
    private List<ResourceReference> effectiveOutboundIPs;
    private Integer idleTimeoutInMinutes;

    public ManagedClusterManagedOutboundIpProfile managedOutboundIpProfile() {
        return this.managedOutboundIpProfile;
    }

    public ManagedClusterNatGatewayProfile withManagedOutboundIpProfile(ManagedClusterManagedOutboundIpProfile managedOutboundIpProfile) {
        this.managedOutboundIpProfile = managedOutboundIpProfile;
        return this;
    }

    public List<ResourceReference> effectiveOutboundIPs() {
        return this.effectiveOutboundIPs;
    }

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public ManagedClusterNatGatewayProfile withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public void validate() {
        if (this.managedOutboundIpProfile() != null) {
            this.managedOutboundIpProfile().validate();
        }
        if (this.effectiveOutboundIPs() != null) {
            this.effectiveOutboundIPs().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedOutboundIPProfile", (JsonSerializable)this.managedOutboundIpProfile);
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterNatGatewayProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterNatGatewayProfile)jsonReader.readObject(reader -> {
            ManagedClusterNatGatewayProfile deserializedManagedClusterNatGatewayProfile = new ManagedClusterNatGatewayProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("managedOutboundIPProfile".equals(fieldName)) {
                    deserializedManagedClusterNatGatewayProfile.managedOutboundIpProfile = ManagedClusterManagedOutboundIpProfile.fromJson(reader);
                    continue;
                }
                if ("effectiveOutboundIPs".equals(fieldName)) {
                    List effectiveOutboundIPs;
                    deserializedManagedClusterNatGatewayProfile.effectiveOutboundIPs = effectiveOutboundIPs = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    continue;
                }
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedManagedClusterNatGatewayProfile.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterNatGatewayProfile;
        });
    }
}

