/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiffDiskSettings;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetManagedDiskParameters;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetOSDisk
implements JsonSerializable<VirtualMachineScaleSetOSDisk> {
    private String name;
    private CachingTypes caching;
    private Boolean writeAcceleratorEnabled;
    private DiskCreateOptionTypes createOption;
    private DiffDiskSettings diffDiskSettings;
    private Integer diskSizeGB;
    private OperatingSystemTypes osType;
    private VirtualHardDisk image;
    private List<String> vhdContainers;
    private VirtualMachineScaleSetManagedDiskParameters managedDisk;
    private DiskDeleteOptionTypes deleteOption;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetOSDisk.class);

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetOSDisk withName(String name) {
        this.name = name;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public VirtualMachineScaleSetOSDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public VirtualMachineScaleSetOSDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public VirtualMachineScaleSetOSDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public DiffDiskSettings diffDiskSettings() {
        return this.diffDiskSettings;
    }

    public VirtualMachineScaleSetOSDisk withDiffDiskSettings(DiffDiskSettings diffDiskSettings) {
        this.diffDiskSettings = diffDiskSettings;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public VirtualMachineScaleSetOSDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public VirtualMachineScaleSetOSDisk withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public VirtualHardDisk image() {
        return this.image;
    }

    public VirtualMachineScaleSetOSDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    public List<String> vhdContainers() {
        return this.vhdContainers;
    }

    public VirtualMachineScaleSetOSDisk withVhdContainers(List<String> vhdContainers) {
        this.vhdContainers = vhdContainers;
        return this;
    }

    public VirtualMachineScaleSetManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public VirtualMachineScaleSetOSDisk withManagedDisk(VirtualMachineScaleSetManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetOSDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.createOption() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property createOption in model VirtualMachineScaleSetOSDisk"));
        }
        if (this.diffDiskSettings() != null) {
            this.diffDiskSettings().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createOption", this.createOption == null ? null : this.createOption.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        jsonWriter.writeJsonField("diffDiskSettings", (JsonSerializable)this.diffDiskSettings);
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeJsonField("image", (JsonSerializable)this.image);
        jsonWriter.writeArrayField("vhdContainers", this.vhdContainers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetOSDisk fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetOSDisk)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetOSDisk deserializedVirtualMachineScaleSetOSDisk = new VirtualMachineScaleSetOSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.createOption = DiskCreateOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.name = reader.getString();
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("diffDiskSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.diffDiskSettings = DiffDiskSettings.fromJson(reader);
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.diskSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.image = VirtualHardDisk.fromJson(reader);
                    continue;
                }
                if ("vhdContainers".equals(fieldName)) {
                    List vhdContainers;
                    deserializedVirtualMachineScaleSetOSDisk.vhdContainers = vhdContainers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.managedDisk = VirtualMachineScaleSetManagedDiskParameters.fromJson(reader);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetOSDisk.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetOSDisk;
        });
    }
}

