/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.OSFamilyInner;
import java.io.IOException;
import java.util.List;

public final class OSFamilyListResult
implements JsonSerializable<OSFamilyListResult> {
    private List<OSFamilyInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(OSFamilyListResult.class);

    public List<OSFamilyInner> value() {
        return this.value;
    }

    public OSFamilyListResult withValue(List<OSFamilyInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public OSFamilyListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model OSFamilyListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static OSFamilyListResult fromJson(JsonReader jsonReader) throws IOException {
        return (OSFamilyListResult)jsonReader.readObject(reader -> {
            OSFamilyListResult deserializedOSFamilyListResult = new OSFamilyListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedOSFamilyListResult.value = value = reader.readArray(reader1 -> OSFamilyInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedOSFamilyListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSFamilyListResult;
        });
    }
}

