/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.KeyVaultAndKeyReference;
import com.azure.resourcemanager.compute.models.KeyVaultAndSecretReference;
import java.io.IOException;

public final class EncryptionSettingsElement
implements JsonSerializable<EncryptionSettingsElement> {
    private KeyVaultAndSecretReference diskEncryptionKey;
    private KeyVaultAndKeyReference keyEncryptionKey;

    public KeyVaultAndSecretReference diskEncryptionKey() {
        return this.diskEncryptionKey;
    }

    public EncryptionSettingsElement withDiskEncryptionKey(KeyVaultAndSecretReference diskEncryptionKey) {
        this.diskEncryptionKey = diskEncryptionKey;
        return this;
    }

    public KeyVaultAndKeyReference keyEncryptionKey() {
        return this.keyEncryptionKey;
    }

    public EncryptionSettingsElement withKeyEncryptionKey(KeyVaultAndKeyReference keyEncryptionKey) {
        this.keyEncryptionKey = keyEncryptionKey;
        return this;
    }

    public void validate() {
        if (this.diskEncryptionKey() != null) {
            this.diskEncryptionKey().validate();
        }
        if (this.keyEncryptionKey() != null) {
            this.keyEncryptionKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("diskEncryptionKey", (JsonSerializable)this.diskEncryptionKey);
        jsonWriter.writeJsonField("keyEncryptionKey", (JsonSerializable)this.keyEncryptionKey);
        return jsonWriter.writeEndObject();
    }

    public static EncryptionSettingsElement fromJson(JsonReader jsonReader) throws IOException {
        return (EncryptionSettingsElement)jsonReader.readObject(reader -> {
            EncryptionSettingsElement deserializedEncryptionSettingsElement = new EncryptionSettingsElement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskEncryptionKey".equals(fieldName)) {
                    deserializedEncryptionSettingsElement.diskEncryptionKey = KeyVaultAndSecretReference.fromJson(reader);
                    continue;
                }
                if ("keyEncryptionKey".equals(fieldName)) {
                    deserializedEncryptionSettingsElement.keyEncryptionKey = KeyVaultAndKeyReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryptionSettingsElement;
        });
    }
}

