/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import java.io.IOException;

public final class DataDisksToAttach
implements JsonSerializable<DataDisksToAttach> {
    private String diskId;
    private Integer lun;
    private CachingTypes caching;
    private DiskDeleteOptionTypes deleteOption;
    private DiskEncryptionSetParameters diskEncryptionSet;
    private Boolean writeAcceleratorEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToAttach.class);

    public String diskId() {
        return this.diskId;
    }

    public DataDisksToAttach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    public Integer lun() {
        return this.lun;
    }

    public DataDisksToAttach withLun(Integer lun) {
        this.lun = lun;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public DataDisksToAttach withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public DataDisksToAttach withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    public DataDisksToAttach withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public DataDisksToAttach withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public void validate() {
        if (this.diskId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property diskId in model DataDisksToAttach"));
        }
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskId", this.diskId);
        jsonWriter.writeNumberField("lun", (Number)this.lun);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet);
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        return jsonWriter.writeEndObject();
    }

    public static DataDisksToAttach fromJson(JsonReader jsonReader) throws IOException {
        return (DataDisksToAttach)jsonReader.readObject(reader -> {
            DataDisksToAttach deserializedDataDisksToAttach = new DataDisksToAttach();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskId".equals(fieldName)) {
                    deserializedDataDisksToAttach.diskId = reader.getString();
                    continue;
                }
                if ("lun".equals(fieldName)) {
                    deserializedDataDisksToAttach.lun = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedDataDisksToAttach.caching = CachingTypes.fromString(reader.getString());
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedDataDisksToAttach.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedDataDisksToAttach.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                    continue;
                }
                if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedDataDisksToAttach.writeAcceleratorEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataDisksToAttach;
        });
    }
}

