/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings;
import java.io.IOException;

public final class VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties
implements JsonSerializable<VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties> {
    private Integer idleTimeoutInMinutes;
    private VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings;
    private SubResource publicIpPrefix;
    private DeleteOptions deleteOption;

    public Integer idleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }

    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutes;
        return this;
    }

    public VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties withDnsSettings(VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public SubResource publicIpPrefix() {
        return this.publicIpPrefix;
    }

    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties withPublicIpPrefix(SubResource publicIpPrefix) {
        this.publicIpPrefix = publicIpPrefix;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("idleTimeoutInMinutes", (Number)this.idleTimeoutInMinutes);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeJsonField("publicIPPrefix", (JsonSerializable)this.publicIpPrefix);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties = new VirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("idleTimeoutInMinutes".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.idleTimeoutInMinutes = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.dnsSettings = VirtualMachineScaleSetPublicIpAddressConfigurationDnsSettings.fromJson(reader);
                    continue;
                }
                if ("publicIPPrefix".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.publicIpPrefix = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties.deleteOption = DeleteOptions.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdatePublicIpAddressConfigurationProperties;
        });
    }
}

