/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicyType;
import com.azure.resourcemanager.eventhubs.models.ThrottlingPolicy;
import java.io.IOException;

public class ApplicationGroupPolicy
implements JsonSerializable<ApplicationGroupPolicy> {
    private ApplicationGroupPolicyType type = ApplicationGroupPolicyType.fromString("ApplicationGroupPolicy");
    private String name;
    private static final ClientLogger LOGGER = new ClientLogger(ApplicationGroupPolicy.class);

    public ApplicationGroupPolicyType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public ApplicationGroupPolicy withName(String name) {
        this.name = name;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ApplicationGroupPolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGroupPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGroupPolicy)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ApplicationGroupPolicy applicationGroupPolicy;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ThrottlingPolicy".equals(discriminatorValue)) {
                    applicationGroupPolicy = ThrottlingPolicy.fromJson(readerToUse.reset());
                    return applicationGroupPolicy;
                }
                applicationGroupPolicy = ApplicationGroupPolicy.fromJsonKnownDiscriminator(readerToUse.reset());
                return applicationGroupPolicy;
            }
        });
    }

    static ApplicationGroupPolicy fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ApplicationGroupPolicy)jsonReader.readObject(reader -> {
            ApplicationGroupPolicy deserializedApplicationGroupPolicy = new ApplicationGroupPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedApplicationGroupPolicy.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationGroupPolicy.type = ApplicationGroupPolicyType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGroupPolicy;
        });
    }
}

