/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.ManagedDatabaseRestoreDetailsClient;
import com.azure.resourcemanager.sql.fluent.models.ManagedDatabaseRestoreDetailsResultInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.RestoreDetailsName;
import reactor.core.publisher.Mono;

public final class ManagedDatabaseRestoreDetailsClientImpl
implements ManagedDatabaseRestoreDetailsClient {
    private final ManagedDatabaseRestoreDetailsService service;
    private final SqlManagementClientImpl client;

    ManagedDatabaseRestoreDetailsClientImpl(SqlManagementClientImpl client) {
        this.service = (ManagedDatabaseRestoreDetailsService)RestProxy.create(ManagedDatabaseRestoreDetailsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ManagedDatabaseRestoreDetailsResultInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, RestoreDetailsName restoreDetailsName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (restoreDetailsName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreDetailsName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, restoreDetailsName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ManagedDatabaseRestoreDetailsResultInner>> getWithResponseAsync(String resourceGroupName, String managedInstanceName, String databaseName, RestoreDetailsName restoreDetailsName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (managedInstanceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter managedInstanceName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (restoreDetailsName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreDetailsName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, managedInstanceName, databaseName, restoreDetailsName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ManagedDatabaseRestoreDetailsResultInner> getAsync(String resourceGroupName, String managedInstanceName, String databaseName, RestoreDetailsName restoreDetailsName) {
        return this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, restoreDetailsName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((ManagedDatabaseRestoreDetailsResultInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ManagedDatabaseRestoreDetailsResultInner> getWithResponse(String resourceGroupName, String managedInstanceName, String databaseName, RestoreDetailsName restoreDetailsName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, managedInstanceName, databaseName, restoreDetailsName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ManagedDatabaseRestoreDetailsResultInner get(String resourceGroupName, String managedInstanceName, String databaseName, RestoreDetailsName restoreDetailsName) {
        return (ManagedDatabaseRestoreDetailsResultInner)((Object)this.getWithResponse(resourceGroupName, managedInstanceName, databaseName, restoreDetailsName, Context.NONE).getValue());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientM")
    public static interface ManagedDatabaseRestoreDetailsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/restoreDetails/{restoreDetailsName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ManagedDatabaseRestoreDetailsResultInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="managedInstanceName") String var3, @PathParam(value="databaseName") String var4, @PathParam(value="restoreDetailsName") RestoreDetailsName var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

