/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.trafficmanager.TrafficManager;
import com.azure.resourcemanager.trafficmanager.fluent.ProfilesClient;
import com.azure.resourcemanager.trafficmanager.fluent.TrafficManagerManagementClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.azure.resourcemanager.trafficmanager.implementation.GeographicHierarchiesImpl;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerProfileImpl;
import com.azure.resourcemanager.trafficmanager.models.CheckProfileDnsNameAvailabilityResult;
import com.azure.resourcemanager.trafficmanager.models.CheckTrafficManagerRelativeDnsNameAvailabilityParameters;
import com.azure.resourcemanager.trafficmanager.models.DnsConfig;
import com.azure.resourcemanager.trafficmanager.models.GeographicHierarchies;
import com.azure.resourcemanager.trafficmanager.models.GeographicLocation;
import com.azure.resourcemanager.trafficmanager.models.MonitorConfig;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfile;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfiles;
import java.util.ArrayList;
import reactor.core.publisher.Mono;

public class TrafficManagerProfilesImpl
extends TopLevelModifiableResourcesImpl<TrafficManagerProfile, TrafficManagerProfileImpl, ProfileInner, ProfilesClient, TrafficManager>
implements TrafficManagerProfiles {
    private GeographicHierarchies geographicHierarchies;

    public TrafficManagerProfilesImpl(TrafficManager trafficManager) {
        super((InnerSupportsListing)((TrafficManagerManagementClient)trafficManager.serviceClient()).getProfiles(), (Manager)trafficManager);
        this.geographicHierarchies = new GeographicHierarchiesImpl(trafficManager, ((TrafficManagerManagementClient)trafficManager.serviceClient()).getGeographicHierarchies());
    }

    @Override
    public CheckProfileDnsNameAvailabilityResult checkDnsNameAvailability(String dnsNameLabel) {
        return (CheckProfileDnsNameAvailabilityResult)this.checkDnsNameAvailabilityAsync(dnsNameLabel).block();
    }

    @Override
    public Mono<CheckProfileDnsNameAvailabilityResult> checkDnsNameAvailabilityAsync(String dnsNameLabel) {
        CheckTrafficManagerRelativeDnsNameAvailabilityParameters parameter = new CheckTrafficManagerRelativeDnsNameAvailabilityParameters().withName(dnsNameLabel).withType("Microsoft.Network/trafficManagerProfiles");
        return ((ProfilesClient)this.inner()).checkTrafficManagerRelativeDnsNameAvailabilityAsync(parameter).map(CheckProfileDnsNameAvailabilityResult::new);
    }

    @Override
    public GeographicLocation getGeographicHierarchyRoot() {
        return this.geographicHierarchies.getRoot();
    }

    protected TrafficManagerProfileImpl wrapModel(String name) {
        return new TrafficManagerProfileImpl(name, new ProfileInner(), (TrafficManager)this.manager());
    }

    protected TrafficManagerProfileImpl wrapModel(ProfileInner inner) {
        if (inner == null) {
            return null;
        }
        return new TrafficManagerProfileImpl(inner.name(), inner, (TrafficManager)this.manager());
    }

    public TrafficManagerProfileImpl define(String name) {
        return this.setDefaults(this.wrapModel(name));
    }

    private TrafficManagerProfileImpl setDefaults(TrafficManagerProfileImpl profile) {
        ((ProfileInner)((Object)profile.innerModel())).withMonitorConfig(new MonitorConfig());
        profile.withHttpMonitoring();
        ((ProfileInner)((Object)profile.innerModel())).withDnsConfig(new DnsConfig());
        profile.withTimeToLive(300);
        ((ProfileInner)((Object)profile.innerModel())).withLocation("global");
        ((ProfileInner)((Object)profile.innerModel())).withEndpoints(new ArrayList<EndpointInner>());
        return profile;
    }
}

