/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.PublishingProfileFormat;
import java.io.IOException;

public final class CsmPublishingProfileOptions
implements JsonSerializable<CsmPublishingProfileOptions> {
    private PublishingProfileFormat format;
    private Boolean includeDisasterRecoveryEndpoints;

    public PublishingProfileFormat format() {
        return this.format;
    }

    public CsmPublishingProfileOptions withFormat(PublishingProfileFormat format) {
        this.format = format;
        return this;
    }

    public Boolean includeDisasterRecoveryEndpoints() {
        return this.includeDisasterRecoveryEndpoints;
    }

    public CsmPublishingProfileOptions withIncludeDisasterRecoveryEndpoints(Boolean includeDisasterRecoveryEndpoints) {
        this.includeDisasterRecoveryEndpoints = includeDisasterRecoveryEndpoints;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("format", this.format == null ? null : this.format.toString());
        jsonWriter.writeBooleanField("includeDisasterRecoveryEndpoints", this.includeDisasterRecoveryEndpoints);
        return jsonWriter.writeEndObject();
    }

    public static CsmPublishingProfileOptions fromJson(JsonReader jsonReader) throws IOException {
        return (CsmPublishingProfileOptions)jsonReader.readObject(reader -> {
            CsmPublishingProfileOptions deserializedCsmPublishingProfileOptions = new CsmPublishingProfileOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("format".equals(fieldName)) {
                    deserializedCsmPublishingProfileOptions.format = PublishingProfileFormat.fromString(reader.getString());
                    continue;
                }
                if ("includeDisasterRecoveryEndpoints".equals(fieldName)) {
                    deserializedCsmPublishingProfileOptions.includeDisasterRecoveryEndpoints = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCsmPublishingProfileOptions;
        });
    }
}

