/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.DeploymentBuildStatus;
import com.azure.resourcemanager.appservice.models.ErrorEntity;
import java.io.IOException;
import java.util.List;

public final class CsmDeploymentStatusProperties
implements JsonSerializable<CsmDeploymentStatusProperties> {
    private String deploymentId;
    private DeploymentBuildStatus status;
    private Integer numberOfInstancesInProgress;
    private Integer numberOfInstancesSuccessful;
    private Integer numberOfInstancesFailed;
    private List<String> failedInstancesLogs;
    private List<ErrorEntity> errors;

    public String deploymentId() {
        return this.deploymentId;
    }

    public CsmDeploymentStatusProperties withDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
        return this;
    }

    public DeploymentBuildStatus status() {
        return this.status;
    }

    public CsmDeploymentStatusProperties withStatus(DeploymentBuildStatus status) {
        this.status = status;
        return this;
    }

    public Integer numberOfInstancesInProgress() {
        return this.numberOfInstancesInProgress;
    }

    public CsmDeploymentStatusProperties withNumberOfInstancesInProgress(Integer numberOfInstancesInProgress) {
        this.numberOfInstancesInProgress = numberOfInstancesInProgress;
        return this;
    }

    public Integer numberOfInstancesSuccessful() {
        return this.numberOfInstancesSuccessful;
    }

    public CsmDeploymentStatusProperties withNumberOfInstancesSuccessful(Integer numberOfInstancesSuccessful) {
        this.numberOfInstancesSuccessful = numberOfInstancesSuccessful;
        return this;
    }

    public Integer numberOfInstancesFailed() {
        return this.numberOfInstancesFailed;
    }

    public CsmDeploymentStatusProperties withNumberOfInstancesFailed(Integer numberOfInstancesFailed) {
        this.numberOfInstancesFailed = numberOfInstancesFailed;
        return this;
    }

    public List<String> failedInstancesLogs() {
        return this.failedInstancesLogs;
    }

    public CsmDeploymentStatusProperties withFailedInstancesLogs(List<String> failedInstancesLogs) {
        this.failedInstancesLogs = failedInstancesLogs;
        return this;
    }

    public List<ErrorEntity> errors() {
        return this.errors;
    }

    public CsmDeploymentStatusProperties withErrors(List<ErrorEntity> errors) {
        this.errors = errors;
        return this;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deploymentId", this.deploymentId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeNumberField("numberOfInstancesInProgress", (Number)this.numberOfInstancesInProgress);
        jsonWriter.writeNumberField("numberOfInstancesSuccessful", (Number)this.numberOfInstancesSuccessful);
        jsonWriter.writeNumberField("numberOfInstancesFailed", (Number)this.numberOfInstancesFailed);
        jsonWriter.writeArrayField("failedInstancesLogs", this.failedInstancesLogs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CsmDeploymentStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CsmDeploymentStatusProperties)jsonReader.readObject(reader -> {
            CsmDeploymentStatusProperties deserializedCsmDeploymentStatusProperties = new CsmDeploymentStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deploymentId".equals(fieldName)) {
                    deserializedCsmDeploymentStatusProperties.deploymentId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCsmDeploymentStatusProperties.status = DeploymentBuildStatus.fromString(reader.getString());
                    continue;
                }
                if ("numberOfInstancesInProgress".equals(fieldName)) {
                    deserializedCsmDeploymentStatusProperties.numberOfInstancesInProgress = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfInstancesSuccessful".equals(fieldName)) {
                    deserializedCsmDeploymentStatusProperties.numberOfInstancesSuccessful = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numberOfInstancesFailed".equals(fieldName)) {
                    deserializedCsmDeploymentStatusProperties.numberOfInstancesFailed = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("failedInstancesLogs".equals(fieldName)) {
                    List failedInstancesLogs;
                    deserializedCsmDeploymentStatusProperties.failedInstancesLogs = failedInstancesLogs = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedCsmDeploymentStatusProperties.errors = errors = reader.readArray(reader1 -> ErrorEntity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCsmDeploymentStatusProperties;
        });
    }
}

