/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsRecordSetImpl;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.models.PtrRecord;
import com.azure.resourcemanager.privatedns.models.PtrRecordSet;
import com.azure.resourcemanager.privatedns.models.RecordType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class PtrRecordSetImpl
extends PrivateDnsRecordSetImpl
implements PtrRecordSet {
    PtrRecordSetImpl(String name, PrivateDnsZoneImpl parent, RecordSetInner innerModel) {
        super(name, RecordType.PTR.toString(), parent, innerModel);
    }

    static PtrRecordSetImpl newRecordSet(String name, PrivateDnsZoneImpl parent) {
        return new PtrRecordSetImpl(name, parent, new RecordSetInner().withPtrRecords(new ArrayList<PtrRecord>()));
    }

    @Override
    public List<String> targetDomainNames() {
        ArrayList<String> targetDomainNames = new ArrayList<String>();
        if (((RecordSetInner)((Object)this.innerModel())).ptrRecords() != null) {
            for (PtrRecord ptrRecord : ((RecordSetInner)((Object)this.innerModel())).ptrRecords()) {
                targetDomainNames.add(ptrRecord.ptrdname());
            }
        }
        return Collections.unmodifiableList(targetDomainNames);
    }

    @Override
    protected RecordSetInner prepareForUpdate(RecordSetInner resource) {
        if (((RecordSetInner)((Object)this.innerModel())).ptrRecords() != null && !((RecordSetInner)((Object)this.innerModel())).ptrRecords().isEmpty()) {
            if (resource.ptrRecords() == null) {
                resource.withPtrRecords(new ArrayList<PtrRecord>());
            }
            resource.ptrRecords().addAll(((RecordSetInner)((Object)this.innerModel())).ptrRecords());
            ((RecordSetInner)((Object)this.innerModel())).ptrRecords().clear();
        }
        if (!this.recordSetRemoveInfo.ptrRecords().isEmpty()) {
            if (resource.ptrRecords() != null) {
                block0: for (PtrRecord recordToRemove : this.recordSetRemoveInfo.ptrRecords()) {
                    for (PtrRecord record : resource.ptrRecords()) {
                        if (!record.ptrdname().equalsIgnoreCase(recordToRemove.ptrdname())) continue;
                        resource.ptrRecords().remove(record);
                        continue block0;
                    }
                }
            }
            this.recordSetRemoveInfo.ptrRecords().clear();
        }
        return resource;
    }
}

