/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ConditionOperator;
import java.io.IOException;
import java.time.Duration;

public final class ManagementEventAggregationCondition
implements JsonSerializable<ManagementEventAggregationCondition> {
    private ConditionOperator operator;
    private Double threshold;
    private Duration windowSize;

    public ConditionOperator operator() {
        return this.operator;
    }

    public ManagementEventAggregationCondition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    public Double threshold() {
        return this.threshold;
    }

    public ManagementEventAggregationCondition withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public ManagementEventAggregationCondition withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeNumberField("threshold", (Number)this.threshold);
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays((Duration)this.windowSize));
        return jsonWriter.writeEndObject();
    }

    public static ManagementEventAggregationCondition fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementEventAggregationCondition)jsonReader.readObject(reader -> {
            ManagementEventAggregationCondition deserializedManagementEventAggregationCondition = new ManagementEventAggregationCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedManagementEventAggregationCondition.operator = ConditionOperator.fromString(reader.getString());
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedManagementEventAggregationCondition.threshold = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("windowSize".equals(fieldName)) {
                    deserializedManagementEventAggregationCondition.windowSize = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementEventAggregationCondition;
        });
    }
}

