/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.KnownColumnDefinitionType;
import java.io.IOException;

public final class ColumnDefinition
implements JsonSerializable<ColumnDefinition> {
    private String name;
    private KnownColumnDefinitionType type;

    public String name() {
        return this.name;
    }

    public ColumnDefinition withName(String name) {
        this.name = name;
        return this;
    }

    public KnownColumnDefinitionType type() {
        return this.type;
    }

    public ColumnDefinition withType(KnownColumnDefinitionType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static ColumnDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ColumnDefinition)jsonReader.readObject(reader -> {
            ColumnDefinition deserializedColumnDefinition = new ColumnDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedColumnDefinition.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedColumnDefinition.type = KnownColumnDefinitionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedColumnDefinition;
        });
    }
}

