/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleProfileInner;
import com.azure.resourcemanager.monitor.fluent.models.AutoscaleSetting;
import com.azure.resourcemanager.monitor.models.AutoscaleNotification;
import com.azure.resourcemanager.monitor.models.PredictiveAutoscalePolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class AutoscaleSettingResourceInner
extends Resource {
    private AutoscaleSetting innerProperties = new AutoscaleSetting();
    private SystemData systemData;
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleSettingResourceInner.class);

    private AutoscaleSetting innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AutoscaleSettingResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AutoscaleSettingResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public List<AutoscaleProfileInner> profiles() {
        return this.innerProperties() == null ? null : this.innerProperties().profiles();
    }

    public AutoscaleSettingResourceInner withProfiles(List<AutoscaleProfileInner> profiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withProfiles(profiles);
        return this;
    }

    public List<AutoscaleNotification> notifications() {
        return this.innerProperties() == null ? null : this.innerProperties().notifications();
    }

    public AutoscaleSettingResourceInner withNotifications(List<AutoscaleNotification> notifications) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withNotifications(notifications);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public AutoscaleSettingResourceInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public PredictiveAutoscalePolicy predictiveAutoscalePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().predictiveAutoscalePolicy();
    }

    public AutoscaleSettingResourceInner withPredictiveAutoscalePolicy(PredictiveAutoscalePolicy predictiveAutoscalePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withPredictiveAutoscalePolicy(predictiveAutoscalePolicy);
        return this;
    }

    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    public AutoscaleSettingResourceInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withName(name);
        return this;
    }

    public String targetResourceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceUri();
    }

    public AutoscaleSettingResourceInner withTargetResourceUri(String targetResourceUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withTargetResourceUri(targetResourceUri);
        return this;
    }

    public String targetResourceLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceLocation();
    }

    public AutoscaleSettingResourceInner withTargetResourceLocation(String targetResourceLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withTargetResourceLocation(targetResourceLocation);
        return this;
    }

    public void validate() {
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model AutoscaleSettingResourceInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AutoscaleSettingResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (AutoscaleSettingResourceInner)((Object)jsonReader.readObject(reader -> {
            AutoscaleSettingResourceInner deserializedAutoscaleSettingResourceInner = new AutoscaleSettingResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAutoscaleSettingResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.innerProperties = AutoscaleSetting.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAutoscaleSettingResourceInner;
        }));
    }
}

