/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ArmRoleReceiver;
import com.azure.resourcemanager.monitor.models.AutomationRunbookReceiver;
import com.azure.resourcemanager.monitor.models.AzureAppPushReceiver;
import com.azure.resourcemanager.monitor.models.AzureFunctionReceiver;
import com.azure.resourcemanager.monitor.models.EmailReceiver;
import com.azure.resourcemanager.monitor.models.EventHubReceiver;
import com.azure.resourcemanager.monitor.models.ItsmReceiver;
import com.azure.resourcemanager.monitor.models.LogicAppReceiver;
import com.azure.resourcemanager.monitor.models.SmsReceiver;
import com.azure.resourcemanager.monitor.models.VoiceReceiver;
import com.azure.resourcemanager.monitor.models.WebhookReceiver;
import java.io.IOException;
import java.util.List;

public final class ActionGroup
implements JsonSerializable<ActionGroup> {
    private String groupShortName;
    private boolean enabled;
    private List<EmailReceiver> emailReceivers;
    private List<SmsReceiver> smsReceivers;
    private List<WebhookReceiver> webhookReceivers;
    private List<ItsmReceiver> itsmReceivers;
    private List<AzureAppPushReceiver> azureAppPushReceivers;
    private List<AutomationRunbookReceiver> automationRunbookReceivers;
    private List<VoiceReceiver> voiceReceivers;
    private List<LogicAppReceiver> logicAppReceivers;
    private List<AzureFunctionReceiver> azureFunctionReceivers;
    private List<ArmRoleReceiver> armRoleReceivers;
    private List<EventHubReceiver> eventHubReceivers;
    private static final ClientLogger LOGGER = new ClientLogger(ActionGroup.class);

    public String groupShortName() {
        return this.groupShortName;
    }

    public ActionGroup withGroupShortName(String groupShortName) {
        this.groupShortName = groupShortName;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public ActionGroup withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<EmailReceiver> emailReceivers() {
        return this.emailReceivers;
    }

    public ActionGroup withEmailReceivers(List<EmailReceiver> emailReceivers) {
        this.emailReceivers = emailReceivers;
        return this;
    }

    public List<SmsReceiver> smsReceivers() {
        return this.smsReceivers;
    }

    public ActionGroup withSmsReceivers(List<SmsReceiver> smsReceivers) {
        this.smsReceivers = smsReceivers;
        return this;
    }

    public List<WebhookReceiver> webhookReceivers() {
        return this.webhookReceivers;
    }

    public ActionGroup withWebhookReceivers(List<WebhookReceiver> webhookReceivers) {
        this.webhookReceivers = webhookReceivers;
        return this;
    }

    public List<ItsmReceiver> itsmReceivers() {
        return this.itsmReceivers;
    }

    public ActionGroup withItsmReceivers(List<ItsmReceiver> itsmReceivers) {
        this.itsmReceivers = itsmReceivers;
        return this;
    }

    public List<AzureAppPushReceiver> azureAppPushReceivers() {
        return this.azureAppPushReceivers;
    }

    public ActionGroup withAzureAppPushReceivers(List<AzureAppPushReceiver> azureAppPushReceivers) {
        this.azureAppPushReceivers = azureAppPushReceivers;
        return this;
    }

    public List<AutomationRunbookReceiver> automationRunbookReceivers() {
        return this.automationRunbookReceivers;
    }

    public ActionGroup withAutomationRunbookReceivers(List<AutomationRunbookReceiver> automationRunbookReceivers) {
        this.automationRunbookReceivers = automationRunbookReceivers;
        return this;
    }

    public List<VoiceReceiver> voiceReceivers() {
        return this.voiceReceivers;
    }

    public ActionGroup withVoiceReceivers(List<VoiceReceiver> voiceReceivers) {
        this.voiceReceivers = voiceReceivers;
        return this;
    }

    public List<LogicAppReceiver> logicAppReceivers() {
        return this.logicAppReceivers;
    }

    public ActionGroup withLogicAppReceivers(List<LogicAppReceiver> logicAppReceivers) {
        this.logicAppReceivers = logicAppReceivers;
        return this;
    }

    public List<AzureFunctionReceiver> azureFunctionReceivers() {
        return this.azureFunctionReceivers;
    }

    public ActionGroup withAzureFunctionReceivers(List<AzureFunctionReceiver> azureFunctionReceivers) {
        this.azureFunctionReceivers = azureFunctionReceivers;
        return this;
    }

    public List<ArmRoleReceiver> armRoleReceivers() {
        return this.armRoleReceivers;
    }

    public ActionGroup withArmRoleReceivers(List<ArmRoleReceiver> armRoleReceivers) {
        this.armRoleReceivers = armRoleReceivers;
        return this;
    }

    public List<EventHubReceiver> eventHubReceivers() {
        return this.eventHubReceivers;
    }

    public ActionGroup withEventHubReceivers(List<EventHubReceiver> eventHubReceivers) {
        this.eventHubReceivers = eventHubReceivers;
        return this;
    }

    public void validate() {
        if (this.groupShortName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property groupShortName in model ActionGroup"));
        }
        if (this.emailReceivers() != null) {
            this.emailReceivers().forEach(e -> e.validate());
        }
        if (this.smsReceivers() != null) {
            this.smsReceivers().forEach(e -> e.validate());
        }
        if (this.webhookReceivers() != null) {
            this.webhookReceivers().forEach(e -> e.validate());
        }
        if (this.itsmReceivers() != null) {
            this.itsmReceivers().forEach(e -> e.validate());
        }
        if (this.azureAppPushReceivers() != null) {
            this.azureAppPushReceivers().forEach(e -> e.validate());
        }
        if (this.automationRunbookReceivers() != null) {
            this.automationRunbookReceivers().forEach(e -> e.validate());
        }
        if (this.voiceReceivers() != null) {
            this.voiceReceivers().forEach(e -> e.validate());
        }
        if (this.logicAppReceivers() != null) {
            this.logicAppReceivers().forEach(e -> e.validate());
        }
        if (this.azureFunctionReceivers() != null) {
            this.azureFunctionReceivers().forEach(e -> e.validate());
        }
        if (this.armRoleReceivers() != null) {
            this.armRoleReceivers().forEach(e -> e.validate());
        }
        if (this.eventHubReceivers() != null) {
            this.eventHubReceivers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("groupShortName", this.groupShortName);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("emailReceivers", this.emailReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("smsReceivers", this.smsReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("webhookReceivers", this.webhookReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("itsmReceivers", this.itsmReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("azureAppPushReceivers", this.azureAppPushReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("automationRunbookReceivers", this.automationRunbookReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("voiceReceivers", this.voiceReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("logicAppReceivers", this.logicAppReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("azureFunctionReceivers", this.azureFunctionReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("armRoleReceivers", this.armRoleReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("eventHubReceivers", this.eventHubReceivers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ActionGroup fromJson(JsonReader jsonReader) throws IOException {
        return (ActionGroup)jsonReader.readObject(reader -> {
            ActionGroup deserializedActionGroup = new ActionGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("groupShortName".equals(fieldName)) {
                    deserializedActionGroup.groupShortName = reader.getString();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedActionGroup.enabled = reader.getBoolean();
                    continue;
                }
                if ("emailReceivers".equals(fieldName)) {
                    List emailReceivers;
                    deserializedActionGroup.emailReceivers = emailReceivers = reader.readArray(reader1 -> EmailReceiver.fromJson(reader1));
                    continue;
                }
                if ("smsReceivers".equals(fieldName)) {
                    List smsReceivers;
                    deserializedActionGroup.smsReceivers = smsReceivers = reader.readArray(reader1 -> SmsReceiver.fromJson(reader1));
                    continue;
                }
                if ("webhookReceivers".equals(fieldName)) {
                    List webhookReceivers;
                    deserializedActionGroup.webhookReceivers = webhookReceivers = reader.readArray(reader1 -> WebhookReceiver.fromJson(reader1));
                    continue;
                }
                if ("itsmReceivers".equals(fieldName)) {
                    List itsmReceivers;
                    deserializedActionGroup.itsmReceivers = itsmReceivers = reader.readArray(reader1 -> ItsmReceiver.fromJson(reader1));
                    continue;
                }
                if ("azureAppPushReceivers".equals(fieldName)) {
                    List azureAppPushReceivers;
                    deserializedActionGroup.azureAppPushReceivers = azureAppPushReceivers = reader.readArray(reader1 -> AzureAppPushReceiver.fromJson(reader1));
                    continue;
                }
                if ("automationRunbookReceivers".equals(fieldName)) {
                    List automationRunbookReceivers;
                    deserializedActionGroup.automationRunbookReceivers = automationRunbookReceivers = reader.readArray(reader1 -> AutomationRunbookReceiver.fromJson(reader1));
                    continue;
                }
                if ("voiceReceivers".equals(fieldName)) {
                    List voiceReceivers;
                    deserializedActionGroup.voiceReceivers = voiceReceivers = reader.readArray(reader1 -> VoiceReceiver.fromJson(reader1));
                    continue;
                }
                if ("logicAppReceivers".equals(fieldName)) {
                    List logicAppReceivers;
                    deserializedActionGroup.logicAppReceivers = logicAppReceivers = reader.readArray(reader1 -> LogicAppReceiver.fromJson(reader1));
                    continue;
                }
                if ("azureFunctionReceivers".equals(fieldName)) {
                    List azureFunctionReceivers;
                    deserializedActionGroup.azureFunctionReceivers = azureFunctionReceivers = reader.readArray(reader1 -> AzureFunctionReceiver.fromJson(reader1));
                    continue;
                }
                if ("armRoleReceivers".equals(fieldName)) {
                    List armRoleReceivers;
                    deserializedActionGroup.armRoleReceivers = armRoleReceivers = reader.readArray(reader1 -> ArmRoleReceiver.fromJson(reader1));
                    continue;
                }
                if ("eventHubReceivers".equals(fieldName)) {
                    List eventHubReceivers;
                    deserializedActionGroup.eventHubReceivers = eventHubReceivers = reader.readArray(reader1 -> EventHubReceiver.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActionGroup;
        });
    }
}

