/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.fluent.models.ReplicationUpdateParametersProperties;
import java.io.IOException;
import java.util.Map;

public final class ReplicationUpdateParameters
implements JsonSerializable<ReplicationUpdateParameters> {
    private Map<String, String> tags;
    private ReplicationUpdateParametersProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ReplicationUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private ReplicationUpdateParametersProperties innerProperties() {
        return this.innerProperties;
    }

    public Boolean regionEndpointEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().regionEndpointEnabled();
    }

    public ReplicationUpdateParameters withRegionEndpointEnabled(Boolean regionEndpointEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ReplicationUpdateParametersProperties();
        }
        this.innerProperties().withRegionEndpointEnabled(regionEndpointEnabled);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ReplicationUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (ReplicationUpdateParameters)jsonReader.readObject(reader -> {
            ReplicationUpdateParameters deserializedReplicationUpdateParameters = new ReplicationUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedReplicationUpdateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedReplicationUpdateParameters.innerProperties = ReplicationUpdateParametersProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedReplicationUpdateParameters;
        });
    }
}

