/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.management.Region;
import com.azure.resourcemanager.containerregistry.fluent.models.TaskInner;
import com.azure.resourcemanager.containerregistry.models.Architecture;
import com.azure.resourcemanager.containerregistry.models.BaseImageTriggerType;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.PlatformUpdateParameters;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RegistryDockerTaskStep;
import com.azure.resourcemanager.containerregistry.models.RegistryEncodedTaskStep;
import com.azure.resourcemanager.containerregistry.models.RegistryFileTaskStep;
import com.azure.resourcemanager.containerregistry.models.RegistrySourceTrigger;
import com.azure.resourcemanager.containerregistry.models.RegistryTaskStep;
import com.azure.resourcemanager.containerregistry.models.TaskStatus;
import com.azure.resourcemanager.containerregistry.models.TriggerProperties;
import com.azure.resourcemanager.containerregistry.models.TriggerStatus;
import com.azure.resourcemanager.containerregistry.models.Variant;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.OffsetDateTime;
import java.util.Map;

public interface RegistryTask
extends Resource,
HasInnerModel<TaskInner>,
Refreshable<RegistryTask>,
Updatable<Update> {
    public String resourceGroupName();

    public String parentRegistryId();

    public ProvisioningState provisioningState();

    public OffsetDateTime creationDate();

    public TaskStatus status();

    public RegistryTaskStep registryTaskStep();

    public int timeout();

    public PlatformProperties platform();

    public int cpuCount();

    public TriggerProperties trigger();

    public Map<String, RegistrySourceTrigger> sourceTriggers();

    public static interface UpdateStages {

        public static interface Timeout {
            public Update withTimeout(int var1);
        }

        public static interface AgentConfiguration {
            public Update withCpuCount(int var1);
        }

        public static interface TriggerTypes {
            public RegistrySourceTrigger.Update updateSourceTrigger(String var1);

            public RegistrySourceTrigger.UpdateDefinitionStages.Blank defineSourceTrigger(String var1);

            public Update updateBaseImageTrigger(String var1, BaseImageTriggerType var2);

            public Update updateBaseImageTrigger(String var1, BaseImageTriggerType var2, TriggerStatus var3);
        }

        public static interface Platform {
            public Update withLinux();

            public Update withWindows();

            public Update withLinux(Architecture var1);

            public Update withWindows(Architecture var1);

            public Update withLinux(Architecture var1, Variant var2);

            public Update withWindows(Architecture var1, Variant var2);

            public Update withPlatform(PlatformUpdateParameters var1);
        }

        public static interface TaskStepType {
            public RegistryFileTaskStep.Update updateFileTaskStep();

            public RegistryEncodedTaskStep.Update updateEncodedTaskStep();

            public RegistryDockerTaskStep.Update updateDockerTaskStep();
        }
    }

    public static interface DefinitionStages {

        public static interface TaskCreatable
        extends AgentConfiguration,
        Timeout,
        SourceTriggerDefinition,
        TriggerTypes,
        Creatable<RegistryTask> {
        }

        public static interface Timeout {
            public TaskCreatable withTimeout(int var1);
        }

        public static interface AgentConfiguration {
            public TaskCreatable withCpuCount(int var1);
        }

        public static interface TriggerTypes {
            public RegistrySourceTrigger.DefinitionStages.Blank defineSourceTrigger(String var1);

            public TaskCreatable withBaseImageTrigger(String var1, BaseImageTriggerType var2);

            public TaskCreatable withBaseImageTrigger(String var1, BaseImageTriggerType var2, TriggerStatus var3);
        }

        public static interface SourceTriggerDefinition {
            public RegistrySourceTrigger.DefinitionStages.Blank defineSourceTrigger(String var1);
        }

        public static interface TaskStepType {
            public RegistryFileTaskStep.DefinitionStages.Blank defineFileTaskStep();

            public RegistryEncodedTaskStep.DefinitionStages.Blank defineEncodedTaskStep();

            public RegistryDockerTaskStep.DefinitionStages.Blank defineDockerTaskStep();
        }

        public static interface Platform {
            public TaskStepType withLinux();

            public TaskStepType withWindows();

            public TaskStepType withLinux(Architecture var1);

            public TaskStepType withWindows(Architecture var1);

            public TaskStepType withLinux(Architecture var1, Variant var2);

            public TaskStepType withWindows(Architecture var1, Variant var2);

            public TaskStepType withPlatform(PlatformProperties var1);
        }

        public static interface Location {
            public Platform withLocation(String var1);

            public Platform withLocation(Region var1);
        }

        public static interface Blank {
            public Location withExistingRegistry(String var1, String var2);
        }
    }

    public static interface Update
    extends UpdateStages.Platform,
    UpdateStages.TriggerTypes,
    UpdateStages.AgentConfiguration,
    UpdateStages.Timeout,
    UpdateStages.TaskStepType,
    Appliable<RegistryTask> {
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.Location,
    DefinitionStages.Platform,
    DefinitionStages.TaskStepType,
    DefinitionStages.SourceTriggerDefinition,
    DefinitionStages.TriggerTypes,
    DefinitionStages.TaskCreatable {
    }
}

