/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.StaticRoute;
import com.azure.resourcemanager.network.models.StaticRoutesConfig;
import java.io.IOException;
import java.util.List;

public final class VnetRoute
implements JsonSerializable<VnetRoute> {
    private StaticRoutesConfig staticRoutesConfig;
    private List<StaticRoute> staticRoutes;
    private List<SubResource> bgpConnections;

    public StaticRoutesConfig staticRoutesConfig() {
        return this.staticRoutesConfig;
    }

    public VnetRoute withStaticRoutesConfig(StaticRoutesConfig staticRoutesConfig) {
        this.staticRoutesConfig = staticRoutesConfig;
        return this;
    }

    public List<StaticRoute> staticRoutes() {
        return this.staticRoutes;
    }

    public VnetRoute withStaticRoutes(List<StaticRoute> staticRoutes) {
        this.staticRoutes = staticRoutes;
        return this;
    }

    public List<SubResource> bgpConnections() {
        return this.bgpConnections;
    }

    public void validate() {
        if (this.staticRoutesConfig() != null) {
            this.staticRoutesConfig().validate();
        }
        if (this.staticRoutes() != null) {
            this.staticRoutes().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("staticRoutesConfig", (JsonSerializable)this.staticRoutesConfig);
        jsonWriter.writeArrayField("staticRoutes", this.staticRoutes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static VnetRoute fromJson(JsonReader jsonReader) throws IOException {
        return (VnetRoute)jsonReader.readObject(reader -> {
            VnetRoute deserializedVnetRoute = new VnetRoute();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("staticRoutesConfig".equals(fieldName)) {
                    deserializedVnetRoute.staticRoutesConfig = StaticRoutesConfig.fromJson(reader);
                    continue;
                }
                if ("staticRoutes".equals(fieldName)) {
                    List staticRoutes;
                    deserializedVnetRoute.staticRoutes = staticRoutes = reader.readArray(reader1 -> StaticRoute.fromJson(reader1));
                    continue;
                }
                if ("bgpConnections".equals(fieldName)) {
                    List bgpConnections;
                    deserializedVnetRoute.bgpConnections = bgpConnections = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVnetRoute;
        });
    }
}

