/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class TopologyParameters
implements JsonSerializable<TopologyParameters> {
    private String targetResourceGroupName;
    private SubResource targetVirtualNetwork;
    private SubResource targetSubnet;

    public String targetResourceGroupName() {
        return this.targetResourceGroupName;
    }

    public TopologyParameters withTargetResourceGroupName(String targetResourceGroupName) {
        this.targetResourceGroupName = targetResourceGroupName;
        return this;
    }

    public SubResource targetVirtualNetwork() {
        return this.targetVirtualNetwork;
    }

    public TopologyParameters withTargetVirtualNetwork(SubResource targetVirtualNetwork) {
        this.targetVirtualNetwork = targetVirtualNetwork;
        return this;
    }

    public SubResource targetSubnet() {
        return this.targetSubnet;
    }

    public TopologyParameters withTargetSubnet(SubResource targetSubnet) {
        this.targetSubnet = targetSubnet;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceGroupName", this.targetResourceGroupName);
        jsonWriter.writeJsonField("targetVirtualNetwork", (JsonSerializable)this.targetVirtualNetwork);
        jsonWriter.writeJsonField("targetSubnet", (JsonSerializable)this.targetSubnet);
        return jsonWriter.writeEndObject();
    }

    public static TopologyParameters fromJson(JsonReader jsonReader) throws IOException {
        return (TopologyParameters)jsonReader.readObject(reader -> {
            TopologyParameters deserializedTopologyParameters = new TopologyParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceGroupName".equals(fieldName)) {
                    deserializedTopologyParameters.targetResourceGroupName = reader.getString();
                    continue;
                }
                if ("targetVirtualNetwork".equals(fieldName)) {
                    deserializedTopologyParameters.targetVirtualNetwork = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("targetSubnet".equals(fieldName)) {
                    deserializedTopologyParameters.targetSubnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopologyParameters;
        });
    }
}

