/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ConfigurationType;
import com.azure.resourcemanager.network.models.DeploymentStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class NetworkManagerDeploymentStatus
implements JsonSerializable<NetworkManagerDeploymentStatus> {
    private OffsetDateTime commitTime;
    private String region;
    private DeploymentStatus deploymentStatus;
    private List<String> configurationIds;
    private ConfigurationType deploymentType;
    private String errorMessage;

    public OffsetDateTime commitTime() {
        return this.commitTime;
    }

    public NetworkManagerDeploymentStatus withCommitTime(OffsetDateTime commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    public String region() {
        return this.region;
    }

    public NetworkManagerDeploymentStatus withRegion(String region) {
        this.region = region;
        return this;
    }

    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public NetworkManagerDeploymentStatus withDeploymentStatus(DeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
        return this;
    }

    public List<String> configurationIds() {
        return this.configurationIds;
    }

    public NetworkManagerDeploymentStatus withConfigurationIds(List<String> configurationIds) {
        this.configurationIds = configurationIds;
        return this;
    }

    public ConfigurationType deploymentType() {
        return this.deploymentType;
    }

    public NetworkManagerDeploymentStatus withDeploymentType(ConfigurationType deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public NetworkManagerDeploymentStatus withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commitTime", this.commitTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.commitTime));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("deploymentStatus", this.deploymentStatus == null ? null : this.deploymentStatus.toString());
        jsonWriter.writeArrayField("configurationIds", this.configurationIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("deploymentType", this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    public static NetworkManagerDeploymentStatus fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkManagerDeploymentStatus)jsonReader.readObject(reader -> {
            NetworkManagerDeploymentStatus deserializedNetworkManagerDeploymentStatus = new NetworkManagerDeploymentStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commitTime".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.commitTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.region = reader.getString();
                    continue;
                }
                if ("deploymentStatus".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.deploymentStatus = DeploymentStatus.fromString(reader.getString());
                    continue;
                }
                if ("configurationIds".equals(fieldName)) {
                    List configurationIds;
                    deserializedNetworkManagerDeploymentStatus.configurationIds = configurationIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("deploymentType".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.deploymentType = ConfigurationType.fromString(reader.getString());
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkManagerDeploymentStatus;
        });
    }
}

