/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.LoadBalancerLoadBalancingRulesClient;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerHealthPerRuleInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.LoadBalancerLoadBalancingRuleListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class LoadBalancerLoadBalancingRulesClientImpl
implements LoadBalancerLoadBalancingRulesClient {
    private final LoadBalancerLoadBalancingRulesService service;
    private final NetworkManagementClientImpl client;

    LoadBalancerLoadBalancingRulesClientImpl(NetworkManagementClientImpl client) {
        this.service = (LoadBalancerLoadBalancingRulesService)RestProxy.create(LoadBalancerLoadBalancingRulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LoadBalancingRuleInner>> listSinglePageAsync(String resourceGroupName, String loadBalancerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (loadBalancerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, loadBalancerName, "2024-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).value(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LoadBalancingRuleInner>> listSinglePageAsync(String resourceGroupName, String loadBalancerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (loadBalancerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, loadBalancerName, "2024-07-01", this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).value(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LoadBalancingRuleInner> listAsync(String resourceGroupName, String loadBalancerName) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, loadBalancerName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<LoadBalancingRuleInner> listAsync(String resourceGroupName, String loadBalancerName, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, loadBalancerName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LoadBalancingRuleInner> list(String resourceGroupName, String loadBalancerName) {
        return new PagedIterable(this.listAsync(resourceGroupName, loadBalancerName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LoadBalancingRuleInner> list(String resourceGroupName, String loadBalancerName, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, loadBalancerName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LoadBalancingRuleInner>> getWithResponseAsync(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (loadBalancerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null."));
        }
        if (loadBalancingRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancingRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, loadBalancerName, loadBalancingRuleName, "2024-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<LoadBalancingRuleInner>> getWithResponseAsync(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (loadBalancerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null."));
        }
        if (loadBalancingRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancingRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, loadBalancerName, loadBalancingRuleName, "2024-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LoadBalancingRuleInner> getAsync(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName) {
        return this.getWithResponseAsync(resourceGroupName, loadBalancerName, loadBalancingRuleName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((LoadBalancingRuleInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LoadBalancingRuleInner> getWithResponse(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, loadBalancerName, loadBalancingRuleName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadBalancingRuleInner get(String resourceGroupName, String loadBalancerName, String loadBalancingRuleName) {
        return (LoadBalancingRuleInner)((Object)this.getWithResponse(resourceGroupName, loadBalancerName, loadBalancingRuleName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> healthWithResponseAsync(String groupName, String loadBalancerName, String loadBalancingRuleName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (loadBalancerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null."));
        }
        if (loadBalancingRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancingRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.health(this.client.getEndpoint(), groupName, loadBalancerName, loadBalancingRuleName, "2024-07-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> healthWithResponseAsync(String groupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (loadBalancerName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancerName is required and cannot be null."));
        }
        if (loadBalancingRuleName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter loadBalancingRuleName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.health(this.client.getEndpoint(), groupName, loadBalancerName, loadBalancingRuleName, "2024-07-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<LoadBalancerHealthPerRuleInner>, LoadBalancerHealthPerRuleInner> beginHealthAsync(String groupName, String loadBalancerName, String loadBalancingRuleName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.healthWithResponseAsync(groupName, loadBalancerName, loadBalancingRuleName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)LoadBalancerHealthPerRuleInner.class), (Type)((Object)LoadBalancerHealthPerRuleInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<LoadBalancerHealthPerRuleInner>, LoadBalancerHealthPerRuleInner> beginHealthAsync(String groupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.healthWithResponseAsync(groupName, loadBalancerName, loadBalancingRuleName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)LoadBalancerHealthPerRuleInner.class), (Type)((Object)LoadBalancerHealthPerRuleInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LoadBalancerHealthPerRuleInner>, LoadBalancerHealthPerRuleInner> beginHealth(String groupName, String loadBalancerName, String loadBalancingRuleName) {
        return this.beginHealthAsync(groupName, loadBalancerName, loadBalancingRuleName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<LoadBalancerHealthPerRuleInner>, LoadBalancerHealthPerRuleInner> beginHealth(String groupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        return this.beginHealthAsync(groupName, loadBalancerName, loadBalancingRuleName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LoadBalancerHealthPerRuleInner> healthAsync(String groupName, String loadBalancerName, String loadBalancingRuleName) {
        return this.beginHealthAsync(groupName, loadBalancerName, loadBalancingRuleName).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<LoadBalancerHealthPerRuleInner> healthAsync(String groupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        return this.beginHealthAsync(groupName, loadBalancerName, loadBalancingRuleName, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadBalancerHealthPerRuleInner health(String groupName, String loadBalancerName, String loadBalancingRuleName) {
        return (LoadBalancerHealthPerRuleInner)this.healthAsync(groupName, loadBalancerName, loadBalancingRuleName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public LoadBalancerHealthPerRuleInner health(String groupName, String loadBalancerName, String loadBalancingRuleName, Context context) {
        return (LoadBalancerHealthPerRuleInner)this.healthAsync(groupName, loadBalancerName, loadBalancingRuleName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LoadBalancingRuleInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).value(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<LoadBalancingRuleInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).value(), ((LoadBalancerLoadBalancingRuleListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface LoadBalancerLoadBalancingRulesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LoadBalancerLoadBalancingRuleListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="loadBalancerName") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules/{loadBalancingRuleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LoadBalancingRuleInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="loadBalancerName") String var3, @PathParam(value="loadBalancingRuleName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{groupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/loadBalancingRules/{loadBalancingRuleName}/health")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> health(@HostParam(value="$host") String var1, @PathParam(value="groupName") String var2, @PathParam(value="loadBalancerName") String var3, @PathParam(value="loadBalancingRuleName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<LoadBalancerLoadBalancingRuleListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

