/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualHubRouteTableV2Inner;
import com.azure.resourcemanager.network.models.HubRoutingPreference;
import com.azure.resourcemanager.network.models.PreferredRoutingGateway;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingState;
import com.azure.resourcemanager.network.models.VirtualHubRouteTable;
import com.azure.resourcemanager.network.models.VirtualRouterAutoScaleConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualHubProperties
implements JsonSerializable<VirtualHubProperties> {
    private SubResource virtualWan;
    private SubResource vpnGateway;
    private SubResource p2SVpnGateway;
    private SubResource expressRouteGateway;
    private SubResource azureFirewall;
    private SubResource securityPartnerProvider;
    private String addressPrefix;
    private VirtualHubRouteTable routeTable;
    private ProvisioningState provisioningState;
    private String securityProviderName;
    private List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S;
    private String sku;
    private RoutingState routingState;
    private List<SubResource> bgpConnections;
    private List<SubResource> ipConfigurations;
    private List<SubResource> routeMaps;
    private Long virtualRouterAsn;
    private List<String> virtualRouterIps;
    private Boolean allowBranchToBranchTraffic;
    private PreferredRoutingGateway preferredRoutingGateway;
    private HubRoutingPreference hubRoutingPreference;
    private VirtualRouterAutoScaleConfiguration virtualRouterAutoScaleConfiguration;

    public SubResource virtualWan() {
        return this.virtualWan;
    }

    public VirtualHubProperties withVirtualWan(SubResource virtualWan) {
        this.virtualWan = virtualWan;
        return this;
    }

    public SubResource vpnGateway() {
        return this.vpnGateway;
    }

    public VirtualHubProperties withVpnGateway(SubResource vpnGateway) {
        this.vpnGateway = vpnGateway;
        return this;
    }

    public SubResource p2SVpnGateway() {
        return this.p2SVpnGateway;
    }

    public VirtualHubProperties withP2SVpnGateway(SubResource p2SVpnGateway) {
        this.p2SVpnGateway = p2SVpnGateway;
        return this;
    }

    public SubResource expressRouteGateway() {
        return this.expressRouteGateway;
    }

    public VirtualHubProperties withExpressRouteGateway(SubResource expressRouteGateway) {
        this.expressRouteGateway = expressRouteGateway;
        return this;
    }

    public SubResource azureFirewall() {
        return this.azureFirewall;
    }

    public VirtualHubProperties withAzureFirewall(SubResource azureFirewall) {
        this.azureFirewall = azureFirewall;
        return this;
    }

    public SubResource securityPartnerProvider() {
        return this.securityPartnerProvider;
    }

    public VirtualHubProperties withSecurityPartnerProvider(SubResource securityPartnerProvider) {
        this.securityPartnerProvider = securityPartnerProvider;
        return this;
    }

    public String addressPrefix() {
        return this.addressPrefix;
    }

    public VirtualHubProperties withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    public VirtualHubRouteTable routeTable() {
        return this.routeTable;
    }

    public VirtualHubProperties withRouteTable(VirtualHubRouteTable routeTable) {
        this.routeTable = routeTable;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String securityProviderName() {
        return this.securityProviderName;
    }

    public VirtualHubProperties withSecurityProviderName(String securityProviderName) {
        this.securityProviderName = securityProviderName;
        return this;
    }

    public List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S() {
        return this.virtualHubRouteTableV2S;
    }

    public VirtualHubProperties withVirtualHubRouteTableV2S(List<VirtualHubRouteTableV2Inner> virtualHubRouteTableV2S) {
        this.virtualHubRouteTableV2S = virtualHubRouteTableV2S;
        return this;
    }

    public String sku() {
        return this.sku;
    }

    public VirtualHubProperties withSku(String sku) {
        this.sku = sku;
        return this;
    }

    public RoutingState routingState() {
        return this.routingState;
    }

    public List<SubResource> bgpConnections() {
        return this.bgpConnections;
    }

    public List<SubResource> ipConfigurations() {
        return this.ipConfigurations;
    }

    public List<SubResource> routeMaps() {
        return this.routeMaps;
    }

    public Long virtualRouterAsn() {
        return this.virtualRouterAsn;
    }

    public VirtualHubProperties withVirtualRouterAsn(Long virtualRouterAsn) {
        this.virtualRouterAsn = virtualRouterAsn;
        return this;
    }

    public List<String> virtualRouterIps() {
        return this.virtualRouterIps;
    }

    public VirtualHubProperties withVirtualRouterIps(List<String> virtualRouterIps) {
        this.virtualRouterIps = virtualRouterIps;
        return this;
    }

    public Boolean allowBranchToBranchTraffic() {
        return this.allowBranchToBranchTraffic;
    }

    public VirtualHubProperties withAllowBranchToBranchTraffic(Boolean allowBranchToBranchTraffic) {
        this.allowBranchToBranchTraffic = allowBranchToBranchTraffic;
        return this;
    }

    public PreferredRoutingGateway preferredRoutingGateway() {
        return this.preferredRoutingGateway;
    }

    public VirtualHubProperties withPreferredRoutingGateway(PreferredRoutingGateway preferredRoutingGateway) {
        this.preferredRoutingGateway = preferredRoutingGateway;
        return this;
    }

    public HubRoutingPreference hubRoutingPreference() {
        return this.hubRoutingPreference;
    }

    public VirtualHubProperties withHubRoutingPreference(HubRoutingPreference hubRoutingPreference) {
        this.hubRoutingPreference = hubRoutingPreference;
        return this;
    }

    public VirtualRouterAutoScaleConfiguration virtualRouterAutoScaleConfiguration() {
        return this.virtualRouterAutoScaleConfiguration;
    }

    public VirtualHubProperties withVirtualRouterAutoScaleConfiguration(VirtualRouterAutoScaleConfiguration virtualRouterAutoScaleConfiguration) {
        this.virtualRouterAutoScaleConfiguration = virtualRouterAutoScaleConfiguration;
        return this;
    }

    public void validate() {
        if (this.routeTable() != null) {
            this.routeTable().validate();
        }
        if (this.virtualHubRouteTableV2S() != null) {
            this.virtualHubRouteTableV2S().forEach(e -> e.validate());
        }
        if (this.virtualRouterAutoScaleConfiguration() != null) {
            this.virtualRouterAutoScaleConfiguration().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualWan", (JsonSerializable)this.virtualWan);
        jsonWriter.writeJsonField("vpnGateway", (JsonSerializable)this.vpnGateway);
        jsonWriter.writeJsonField("p2SVpnGateway", (JsonSerializable)this.p2SVpnGateway);
        jsonWriter.writeJsonField("expressRouteGateway", (JsonSerializable)this.expressRouteGateway);
        jsonWriter.writeJsonField("azureFirewall", (JsonSerializable)this.azureFirewall);
        jsonWriter.writeJsonField("securityPartnerProvider", (JsonSerializable)this.securityPartnerProvider);
        jsonWriter.writeStringField("addressPrefix", this.addressPrefix);
        jsonWriter.writeJsonField("routeTable", (JsonSerializable)this.routeTable);
        jsonWriter.writeStringField("securityProviderName", this.securityProviderName);
        jsonWriter.writeArrayField("virtualHubRouteTableV2s", this.virtualHubRouteTableV2S, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("sku", this.sku);
        jsonWriter.writeNumberField("virtualRouterAsn", (Number)this.virtualRouterAsn);
        jsonWriter.writeArrayField("virtualRouterIps", this.virtualRouterIps, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("allowBranchToBranchTraffic", this.allowBranchToBranchTraffic);
        jsonWriter.writeStringField("preferredRoutingGateway", this.preferredRoutingGateway == null ? null : this.preferredRoutingGateway.toString());
        jsonWriter.writeStringField("hubRoutingPreference", this.hubRoutingPreference == null ? null : this.hubRoutingPreference.toString());
        jsonWriter.writeJsonField("virtualRouterAutoScaleConfiguration", (JsonSerializable)this.virtualRouterAutoScaleConfiguration);
        return jsonWriter.writeEndObject();
    }

    public static VirtualHubProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualHubProperties)jsonReader.readObject(reader -> {
            VirtualHubProperties deserializedVirtualHubProperties = new VirtualHubProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualWan".equals(fieldName)) {
                    deserializedVirtualHubProperties.virtualWan = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("vpnGateway".equals(fieldName)) {
                    deserializedVirtualHubProperties.vpnGateway = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("p2SVpnGateway".equals(fieldName)) {
                    deserializedVirtualHubProperties.p2SVpnGateway = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("expressRouteGateway".equals(fieldName)) {
                    deserializedVirtualHubProperties.expressRouteGateway = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("azureFirewall".equals(fieldName)) {
                    deserializedVirtualHubProperties.azureFirewall = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("securityPartnerProvider".equals(fieldName)) {
                    deserializedVirtualHubProperties.securityPartnerProvider = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("addressPrefix".equals(fieldName)) {
                    deserializedVirtualHubProperties.addressPrefix = reader.getString();
                    continue;
                }
                if ("routeTable".equals(fieldName)) {
                    deserializedVirtualHubProperties.routeTable = VirtualHubRouteTable.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualHubProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("securityProviderName".equals(fieldName)) {
                    deserializedVirtualHubProperties.securityProviderName = reader.getString();
                    continue;
                }
                if ("virtualHubRouteTableV2s".equals(fieldName)) {
                    List virtualHubRouteTableV2S;
                    deserializedVirtualHubProperties.virtualHubRouteTableV2S = virtualHubRouteTableV2S = reader.readArray(reader1 -> VirtualHubRouteTableV2Inner.fromJson(reader1));
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVirtualHubProperties.sku = reader.getString();
                    continue;
                }
                if ("routingState".equals(fieldName)) {
                    deserializedVirtualHubProperties.routingState = RoutingState.fromString(reader.getString());
                    continue;
                }
                if ("bgpConnections".equals(fieldName)) {
                    List bgpConnections;
                    deserializedVirtualHubProperties.bgpConnections = bgpConnections = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedVirtualHubProperties.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("routeMaps".equals(fieldName)) {
                    List routeMaps;
                    deserializedVirtualHubProperties.routeMaps = routeMaps = reader.readArray(reader1 -> SubResource.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("virtualRouterAsn".equals(fieldName)) {
                    deserializedVirtualHubProperties.virtualRouterAsn = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("virtualRouterIps".equals(fieldName)) {
                    List virtualRouterIps;
                    deserializedVirtualHubProperties.virtualRouterIps = virtualRouterIps = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("allowBranchToBranchTraffic".equals(fieldName)) {
                    deserializedVirtualHubProperties.allowBranchToBranchTraffic = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("preferredRoutingGateway".equals(fieldName)) {
                    deserializedVirtualHubProperties.preferredRoutingGateway = PreferredRoutingGateway.fromString(reader.getString());
                    continue;
                }
                if ("hubRoutingPreference".equals(fieldName)) {
                    deserializedVirtualHubProperties.hubRoutingPreference = HubRoutingPreference.fromString(reader.getString());
                    continue;
                }
                if ("virtualRouterAutoScaleConfiguration".equals(fieldName)) {
                    deserializedVirtualHubProperties.virtualRouterAutoScaleConfiguration = VirtualRouterAutoScaleConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualHubProperties;
        });
    }
}

