/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ScopeConnectionProperties;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import java.io.IOException;

public final class ScopeConnectionInner
extends ChildResource {
    private ScopeConnectionProperties innerProperties;
    private SystemData systemData;
    private String etag;
    private String type;
    private String name;
    private String id;

    private ScopeConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public ScopeConnectionInner withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopeConnectionProperties();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    public ScopeConnectionInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopeConnectionProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    public ScopeConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ScopeConnectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopeConnectionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ScopeConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (ScopeConnectionInner)((Object)jsonReader.readObject(reader -> {
            ScopeConnectionInner deserializedScopeConnectionInner = new ScopeConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedScopeConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedScopeConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScopeConnectionInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedScopeConnectionInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedScopeConnectionInner.innerProperties = ScopeConnectionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedScopeConnectionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScopeConnectionInner;
        }));
    }
}

