/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AccessRuleDirection;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.PerimeterBasedAccessRule;
import com.azure.resourcemanager.network.models.SubscriptionId;
import java.io.IOException;
import java.util.List;

public final class NspAccessRuleProperties
implements JsonSerializable<NspAccessRuleProperties> {
    private NspProvisioningState provisioningState;
    private AccessRuleDirection direction;
    private List<String> addressPrefixes;
    private List<String> fullyQualifiedDomainNames;
    private List<SubscriptionId> subscriptions;
    private List<PerimeterBasedAccessRule> networkSecurityPerimeters;
    private List<String> emailAddresses;
    private List<String> phoneNumbers;
    private List<String> serviceTags;

    public NspProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public AccessRuleDirection direction() {
        return this.direction;
    }

    public NspAccessRuleProperties withDirection(AccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    public NspAccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    public NspAccessRuleProperties withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        this.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
        return this;
    }

    public List<SubscriptionId> subscriptions() {
        return this.subscriptions;
    }

    public NspAccessRuleProperties withSubscriptions(List<SubscriptionId> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public List<PerimeterBasedAccessRule> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    public NspAccessRuleProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    public NspAccessRuleProperties withPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    public List<String> serviceTags() {
        return this.serviceTags;
    }

    public NspAccessRuleProperties withServiceTags(List<String> serviceTags) {
        this.serviceTags = serviceTags;
        return this;
    }

    public void validate() {
        if (this.subscriptions() != null) {
            this.subscriptions().forEach(e -> e.validate());
        }
        if (this.networkSecurityPerimeters() != null) {
            this.networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fullyQualifiedDomainNames", this.fullyQualifiedDomainNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serviceTags", this.serviceTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static NspAccessRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NspAccessRuleProperties)jsonReader.readObject(reader -> {
            NspAccessRuleProperties deserializedNspAccessRuleProperties = new NspAccessRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNspAccessRuleProperties.provisioningState = NspProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("direction".equals(fieldName)) {
                    deserializedNspAccessRuleProperties.direction = AccessRuleDirection.fromString(reader.getString());
                    continue;
                }
                if ("addressPrefixes".equals(fieldName)) {
                    List addressPrefixes;
                    deserializedNspAccessRuleProperties.addressPrefixes = addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("fullyQualifiedDomainNames".equals(fieldName)) {
                    List fullyQualifiedDomainNames;
                    deserializedNspAccessRuleProperties.fullyQualifiedDomainNames = fullyQualifiedDomainNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("subscriptions".equals(fieldName)) {
                    List subscriptions;
                    deserializedNspAccessRuleProperties.subscriptions = subscriptions = reader.readArray(reader1 -> SubscriptionId.fromJson(reader1));
                    continue;
                }
                if ("networkSecurityPerimeters".equals(fieldName)) {
                    List networkSecurityPerimeters;
                    deserializedNspAccessRuleProperties.networkSecurityPerimeters = networkSecurityPerimeters = reader.readArray(reader1 -> PerimeterBasedAccessRule.fromJson(reader1));
                    continue;
                }
                if ("emailAddresses".equals(fieldName)) {
                    List emailAddresses;
                    deserializedNspAccessRuleProperties.emailAddresses = emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("phoneNumbers".equals(fieldName)) {
                    List phoneNumbers;
                    deserializedNspAccessRuleProperties.phoneNumbers = phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("serviceTags".equals(fieldName)) {
                    List serviceTags;
                    deserializedNspAccessRuleProperties.serviceTags = serviceTags = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspAccessRuleProperties;
        });
    }
}

