/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AzureFirewallApplicationRule;
import com.azure.resourcemanager.network.models.AzureFirewallRCAction;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class AzureFirewallApplicationRuleCollectionPropertiesFormat
implements JsonSerializable<AzureFirewallApplicationRuleCollectionPropertiesFormat> {
    private Integer priority;
    private AzureFirewallRCAction action;
    private List<AzureFirewallApplicationRule> rules;
    private ProvisioningState provisioningState;

    public Integer priority() {
        return this.priority;
    }

    public AzureFirewallApplicationRuleCollectionPropertiesFormat withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public AzureFirewallRCAction action() {
        return this.action;
    }

    public AzureFirewallApplicationRuleCollectionPropertiesFormat withAction(AzureFirewallRCAction action) {
        this.action = action;
        return this;
    }

    public List<AzureFirewallApplicationRule> rules() {
        return this.rules;
    }

    public AzureFirewallApplicationRuleCollectionPropertiesFormat withRules(List<AzureFirewallApplicationRule> rules) {
        this.rules = rules;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.action() != null) {
            this.action().validate();
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("priority", (Number)this.priority);
        jsonWriter.writeJsonField("action", (JsonSerializable)this.action);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static AzureFirewallApplicationRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFirewallApplicationRuleCollectionPropertiesFormat)jsonReader.readObject(reader -> {
            AzureFirewallApplicationRuleCollectionPropertiesFormat deserializedAzureFirewallApplicationRuleCollectionPropertiesFormat = new AzureFirewallApplicationRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("priority".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollectionPropertiesFormat.priority = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollectionPropertiesFormat.action = AzureFirewallRCAction.fromJson(reader);
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedAzureFirewallApplicationRuleCollectionPropertiesFormat.rules = rules = reader.readArray(reader1 -> AzureFirewallApplicationRule.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAzureFirewallApplicationRuleCollectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFirewallApplicationRuleCollectionPropertiesFormat;
        });
    }
}

