/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayListenerPropertiesFormat
implements JsonSerializable<ApplicationGatewayListenerPropertiesFormat> {
    private SubResource frontendIpConfiguration;
    private SubResource frontendPort;
    private ApplicationGatewayProtocol protocol;
    private SubResource sslCertificate;
    private SubResource sslProfile;
    private ProvisioningState provisioningState;
    private List<String> hostNames;

    public SubResource frontendIpConfiguration() {
        return this.frontendIpConfiguration;
    }

    public ApplicationGatewayListenerPropertiesFormat withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        this.frontendIpConfiguration = frontendIpConfiguration;
        return this;
    }

    public SubResource frontendPort() {
        return this.frontendPort;
    }

    public ApplicationGatewayListenerPropertiesFormat withFrontendPort(SubResource frontendPort) {
        this.frontendPort = frontendPort;
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.protocol;
    }

    public ApplicationGatewayListenerPropertiesFormat withProtocol(ApplicationGatewayProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public SubResource sslCertificate() {
        return this.sslCertificate;
    }

    public ApplicationGatewayListenerPropertiesFormat withSslCertificate(SubResource sslCertificate) {
        this.sslCertificate = sslCertificate;
        return this;
    }

    public SubResource sslProfile() {
        return this.sslProfile;
    }

    public ApplicationGatewayListenerPropertiesFormat withSslProfile(SubResource sslProfile) {
        this.sslProfile = sslProfile;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<String> hostNames() {
        return this.hostNames;
    }

    public ApplicationGatewayListenerPropertiesFormat withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontendIPConfiguration", (JsonSerializable)this.frontendIpConfiguration);
        jsonWriter.writeJsonField("frontendPort", (JsonSerializable)this.frontendPort);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeJsonField("sslCertificate", (JsonSerializable)this.sslCertificate);
        jsonWriter.writeJsonField("sslProfile", (JsonSerializable)this.sslProfile);
        jsonWriter.writeArrayField("hostNames", this.hostNames, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayListenerPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayListenerPropertiesFormat)jsonReader.readObject(reader -> {
            ApplicationGatewayListenerPropertiesFormat deserializedApplicationGatewayListenerPropertiesFormat = new ApplicationGatewayListenerPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("frontendIPConfiguration".equals(fieldName)) {
                    deserializedApplicationGatewayListenerPropertiesFormat.frontendIpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("frontendPort".equals(fieldName)) {
                    deserializedApplicationGatewayListenerPropertiesFormat.frontendPort = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("protocol".equals(fieldName)) {
                    deserializedApplicationGatewayListenerPropertiesFormat.protocol = ApplicationGatewayProtocol.fromString(reader.getString());
                    continue;
                }
                if ("sslCertificate".equals(fieldName)) {
                    deserializedApplicationGatewayListenerPropertiesFormat.sslCertificate = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("sslProfile".equals(fieldName)) {
                    deserializedApplicationGatewayListenerPropertiesFormat.sslProfile = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayListenerPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("hostNames".equals(fieldName)) {
                    List hostNames;
                    deserializedApplicationGatewayListenerPropertiesFormat.hostNames = hostNames = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayListenerPropertiesFormat;
        });
    }
}

